package com.biz.crm.wechatpay.v3.model;

import com.google.gson.annotations.SerializedName;

/**
 * 转账失败原因枚举
 */
public enum FailReasonType {
    //该用户账户被冻结
    @SerializedName("ACCOUNT_FROZEN")
    ACCOUNT_FROZEN,

    //收款人未实名认证，需要用户完成微信实名认证
    @SerializedName("REAL_NAME_CHECK_FAIL")
    REAL_NAME_CHECK_FAIL,

    //收款人姓名校验不通过，请核实信息
    @SerializedName("NAME_NOT_CORRECT")
    NAME_NOT_CORRECT,

    //Openid格式错误或者不属于商家公众账号
    @SerializedName("OPENID_INVALID")
    OPENID_INVALID,

    //超过用户单笔收款额度，核实产品设置是否准确
    @SerializedName("TRANSFER_QUOTA_EXCEED")
    TRANSFER_QUOTA_EXCEED,

    //超过用户单日收款额度，核实产品设置是否准确
    @SerializedName("DAY_RECEIVED_QUOTA_EXCEED")
    DAY_RECEIVED_QUOTA_EXCEED,

    //超过用户单月收款额度，核实产品设置是否准确
    @SerializedName("MONTH_RECEIVED_QUOTA_EXCEED")
    MONTH_RECEIVED_QUOTA_EXCEED,

    //超过用户单日收款次数，核实产品设置是否准确
    @SerializedName("DAY_RECEIVED_COUNT_EXCEED")
    DAY_RECEIVED_COUNT_EXCEED,

    //未开通该权限或权限被冻结，请核实产品权限状态
    @SerializedName("PRODUCT_AUTH_CHECK_FAIL")
    PRODUCT_AUTH_CHECK_FAIL,

    //超过系统重试期，系统自动关闭
    @SerializedName("OVERDUE_CLOSE")
    OVERDUE_CLOSE,

    //收款人身份证校验不通过，请核实信息
    @SerializedName("ID_CARD_NOT_CORRECT")
    ID_CARD_NOT_CORRECT,

    //该用户账户不存在
    @SerializedName("ACCOUNT_NOT_EXIST")
    ACCOUNT_NOT_EXIST,

    //该笔转账可能存在风险，已被微信拦截
    @SerializedName("TRANSFER_RISK")
    TRANSFER_RISK,

    //其它失败原因
    @SerializedName("OTHER_FAIL_REASON_TYPE")
    OTHER_FAIL_REASON_TYPE,

    //用户账户收款受限，请引导用户在微信支付查看详情
    @SerializedName("REALNAME_ACCOUNT_RECEIVED_QUOTA_EXCEED")
    REALNAME_ACCOUNT_RECEIVED_QUOTA_EXCEED,

    //未配置该用户为转账收款人，请在产品设置中调整，添加该用户为收款人
    @SerializedName("RECEIVE_ACCOUNT_NOT_PERMMIT")
    RECEIVE_ACCOUNT_NOT_PERMMIT,

    //用户账户收款异常，请联系用户完善其在微信支付的身份信息以继续收款
    @SerializedName("PAYEE_ACCOUNT_ABNORMAL")
    PAYEE_ACCOUNT_ABNORMAL,

    //商户账户付款受限，可前往商户平台获取解除功能限制指引
    @SerializedName("PAYER_ACCOUNT_ABNORMAL")
    PAYER_ACCOUNT_ABNORMAL,

    //该转账场景暂不可用，请确认转账场景ID是否正确
    @SerializedName("TRANSFER_SCENE_UNAVAILABLE")
    TRANSFER_SCENE_UNAVAILABLE,

    //你尚未获取该转账场景，请确认转账场景ID是否正确
    @SerializedName("TRANSFER_SCENE_INVALID")
    TRANSFER_SCENE_INVALID,

    //转账备注设置失败， 请调整后重新再试
    @SerializedName("TRANSFER_REMARK_SET_FAIL")
    TRANSFER_REMARK_SET_FAIL,

    //请前往商户平台-商家转账到零钱-前往功能-转账场景中添加
    @SerializedName("RECEIVE_ACCOUNT_NOT_CONFIGURE")
    RECEIVE_ACCOUNT_NOT_CONFIGURE,

    //超出用户单月转账收款20w限额，本月不支持继续向该用户付款
    @SerializedName("BLOCK_B2C_USERLIMITAMOUNT_BSRULE_MONTH")
    BLOCK_B2C_USERLIMITAMOUNT_BSRULE_MONTH,

    //用户账户存在风险收款受限，本月不支持继续向该用户付款
    @SerializedName("BLOCK_B2C_USERLIMITAMOUNT_MONTH")
    BLOCK_B2C_USERLIMITAMOUNT_MONTH,

    //商户员工（转账验密人）已驳回转账
    @SerializedName("MERCHANT_REJECT")
    MERCHANT_REJECT,

    //商户员工（转账验密人）超时未验密
    @SerializedName("MERCHANT_NOT_CONFIRM")
    MERCHANT_NOT_CONFIRM
}
