package com.biz.crm.wechatpay.v3.model;

import com.google.gson.annotations.SerializedName;
import com.wechat.pay.java.core.cipher.Encryption;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;

/**
 * 发起转账请求对象
 */
public class InitiateBatchTransferRequest {
    /**
     * 商户appid 必填
     * 说明：申请商户号的appid或商户号绑定的appid（企业号corpid即为此appid）
     */
    @SerializedName("appid")
    private String appid;

    /**
     * 商家批次单号 必填
     * 说明：商户系统内部的商家批次单号，要求此参数只能由数字、大小写字母组成，在商户系统内部唯一
     */
    @SerializedName("out_batch_no")
    private String outBatchNo;

    /**
     * 批次名称 必填
     * 说明：该笔批量转账的名称
     */
    @SerializedName("batch_name")
    private String batchName;

    /**
     * 批次备注 必填
     * 说明：转账说明，UTF8编码，最多允许32个字符
     */
    @SerializedName("batch_remark")
    private String batchRemark;

    /**
     * 转账总金额 必填
     * 说明：转账金额单位为“分”。转账总金额必须与批次内所有明细转账金额之和保持一致，否则无法发起转账操作
     */
    @SerializedName("total_amount")
    private Long totalAmount;

    /**
     * 转账总笔数 必填
     * 说明：一个转账批次单最多发起一千笔转账。转账总笔数必须与批次内所有明细之和保持一致，否则无法发起转账操作
     */
    @SerializedName("total_num")
    private Integer totalNum;

    /**
     * 转账明细列表 必填
     * 说明：发起批量转账的明细列表，最多一千笔
     */
    @Encryption
    @SerializedName("transfer_detail_list")
    private List<TransferDetailInput> transferDetailList = new ArrayList<>();

    /**
     * 转账场景ID 选填
     * 说明：该批次转账使用的转账场景，如不填写则使用商家的默认场景，如无默认场景可为空，可前往“商家转账到零钱-前往功能”中申请。 如：1001-现金营销
     */
    @SerializedName("transfer_scene_id")
    private String transferSceneId;

    /**
     * 通知地址 选填
     * 说明：异步接收微信支付结果通知的回调地址，通知url必须为公网可访问的url，必须为https，不能携带参数。
     */
    @SerializedName("notify_url")
    private String notifyUrl;

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getOutBatchNo() {
        return outBatchNo;
    }

    public void setOutBatchNo(String outBatchNo) {
        this.outBatchNo = outBatchNo;
    }

    public String getBatchName() {
        return batchName;
    }

    public void setBatchName(String batchName) {
        this.batchName = batchName;
    }

    public String getBatchRemark() {
        return batchRemark;
    }

    public void setBatchRemark(String batchRemark) {
        this.batchRemark = batchRemark;
    }

    public Long getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(Long totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Integer getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }

    public List<TransferDetailInput> getTransferDetailList() {
        return transferDetailList;
    }

    public void setTransferDetailList(List<TransferDetailInput> transferDetailList) {
        this.transferDetailList = transferDetailList;
    }

    public String getTransferSceneId() {
        return transferSceneId;
    }

    public void setTransferSceneId(String transferSceneId) {
        this.transferSceneId = transferSceneId;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public InitiateBatchTransferRequest cloneWithCipher(UnaryOperator<String> s) {
        InitiateBatchTransferRequest copy = new InitiateBatchTransferRequest();
        copy.appid = appid;
        copy.outBatchNo = outBatchNo;
        copy.batchName = batchName;
        copy.batchRemark = batchRemark;
        copy.totalAmount = totalAmount;
        copy.totalNum = totalNum;
        if (transferDetailList != null && !transferDetailList.isEmpty()) {
            copy.transferDetailList = new ArrayList<>();
            for (TransferDetailInput val : transferDetailList) {
                if (val != null) {
                    copy.transferDetailList.add(val.cloneWithCipher(s));
                }
            }
        }
        copy.transferSceneId = transferSceneId;
        copy.notifyUrl = notifyUrl;
        return copy;
    }
}
