package com.biz.crm.wechatpay.v3.model;

import com.google.gson.annotations.SerializedName;

/**
 * 通过微信明回调通知回传数据
 */
public class TransferNotifyDetailResponse {
    /**
     * 商家批次单号 必
     * 说明：商户系统内部的商家批次单号，在商户系统内部唯一
     */
    @SerializedName("out_batch_no")
    private String outBatchNo;

    /**
     * 微信批次单号 必填
     * 说明：微信批次单号，微信商家转账系统返回的唯一标识
     */
    @SerializedName("batch_id")
    private String batchId;

    /**
     * 批次状态 必填
     * 说明：WAIT_PAY: 待付款确认。需要付款出资商户在商家助手小程序或服务商助手小程序进行付款确认
     *      ACCEPTED:已受理。批次已受理成功，若发起批量转账的30分钟后，转账批次单仍处于该状态，可能原因是商户账户余额不足等。商户可查询账户资金流水，若该笔转账批次单的扣款已经发生，则表示批次已经进入转账中，请再次查单确认
     *      PROCESSING:转账中。已开始处理批次内的转账明细单
     *      FINISHED:已完成。批次内的所有转账明细单都已处理完成
     *      CLOSED:已关闭。可查询具体的批次关闭原因确认
     */
    @SerializedName("batch_status")
    private String batchStatus;

    /**
     * 批次总笔数 必填
     * 说明：转账总笔数。
     */
    @SerializedName("total_num")
    private Integer totalNum;

    /**
     * 批次总金额 必填
     * 说明：转账总金额，单位为“分”。
     */
    @SerializedName("total_amount")
    private Integer totalAmount;

    /**
     * 转账成功金额 必填
     * 说明：转账成功的金额，单位为“分”。当批次状态为“PROCESSING”（转账中）时，转账成功金额随时可能变化
     */
    @SerializedName("success_amount")
    private Integer successAmount;

    /**
     * 转账成功笔数 必填
     * 说明：转账成功的笔数。当批次状态为“PROCESSING”（转账中）时，转账成功笔数随时可能变化
     */
    @SerializedName("success_num")
    private Integer successNum;

    /**
     * 转账失败金额 必填
     * 说明：转账失败的金额，单位为“分”
     */
    @SerializedName("fail_amount")
    private Integer failAmount;

    /**
     * 转账失败笔数 必填
     * 说明：转账失败的笔数
     */
    @SerializedName("fail_num")
    private FailReasonType fail_num;

    /**
     * 商户号 必填
     * 说明：微信支付分配的商户号
     */
    @SerializedName("mchid")
    private String mchid;
    /**
     * 明细更新时间 必填
     * 说明：明细最后一次状态变更的时间，按照使用rfc3339所定义的格式，格式为YYYY-MM-DDThh:mm:ss+TIMEZONE
     */
    @SerializedName("update_time")
    private String updateTime;

    public String getOutBatchNo() {
        return outBatchNo;
    }

    public void setOutBatchNo(String outBatchNo) {
        this.outBatchNo = outBatchNo;
    }

    public String getBatchId() {
        return batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getBatchStatus() {
        return batchStatus;
    }

    public void setBatchStatus(String batchStatus) {
        this.batchStatus = batchStatus;
    }

    public Integer getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }

    public Integer getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(Integer totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Integer getSuccessAmount() {
        return successAmount;
    }

    public void setSuccessAmount(Integer successAmount) {
        this.successAmount = successAmount;
    }

    public Integer getSuccessNum() {
        return successNum;
    }

    public void setSuccessNum(Integer successNum) {
        this.successNum = successNum;
    }

    public Integer getFailAmount() {
        return failAmount;
    }

    public void setFailAmount(Integer failAmount) {
        this.failAmount = failAmount;
    }

    public FailReasonType getFail_num() {
        return fail_num;
    }

    public void setFail_num(FailReasonType fail_num) {
        this.fail_num = fail_num;
    }

    public String getMchid() {
        return mchid;
    }

    public void setMchid(String mchid) {
        this.mchid = mchid;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }
}
