package com.biz.crm.wechatpay.v3.service;

import com.biz.crm.wechatpay.v3.model.*;

import javax.servlet.http.HttpServletRequest;

/***
 * 微信商户号转账V3老版本批量转账服务接口
 */
public interface WechatPayV3TransferBatchService {

    /***
     * 发起批量转账
     * @param request 请求对象
     * @return 响应对象
     */
    InitiateBatchTransferResponse batchTransfer(InitiateBatchTransferRequest request);

    /***
     * 通过微信批次单号查询批次单
     * @param request
     *        batchId 为微信批次单号 必传
     * @return 转账结果信息
     */
    TransferBatchResponse getTransferBatchByNo(GetTransferBatchByNoRequest request);


    /***
     * 通过商家批次单号查询批次单
     * @param request
     *        outBatchNo 为商户批次单号 必传
     * @return 转账结果信息
     */
    TransferBatchResponse getTransferBatchByOutNo(GetTransferBatchByOutNoRequest request);

    /**
     * 通过微信明细单号查询明细单
     *
     * @param request
     * @return
     */
    TransferDetailResponse getTransferDetailByNo(GetTransferDetailByNoRequest request);


    /**
     * 通过商家明细单号查询明细单
     *
     * @param request
     * @return
     */
    TransferDetailResponse getTransferDetailByOutNo(GetTransferDetailByOutNoRequest request);


    /**
     * 打款回调接口处理逻辑
     * @param request 请求对象
     * @return 转账结果信息
     *         若遇ValidationException 表示校验不通过
     */
    TransferNotifyDetailResponse doNotify(HttpServletRequest request);
}
