package com.biz.crm.wechatpay.v3plus.model;

import com.google.gson.annotations.SerializedName;

import java.util.Objects;

/**
 * 撤销转账返回结果
 */
public class CancelBillsDetailResponse {

    /**
     * 商户单号 必填
     * 说明：商户系统内部的商家单号，要求此参数只能由数字、大小写字母组成，在商户系统内部唯一
     */
    @SerializedName("out_bill_no")
    private String outBillNo;

    /**
     * 商家转账订单号 必填
     * 说明：商家转账订单的主键，唯一定义此资源的标识
     */
    @SerializedName("transfer_bill_no")
    private String transferBillNo;

    /**
     * 单据状态 必填
     * 说明：单据状态
     * 如：
     * CANCELING: 撤销中；
     * CANCELLED:已撤销
     */
    @SerializedName("state")
    private String state;
    /**
     * 最后一次状态变更时间 必填
     * 说明：单据最后更新时间，按照使用rfc3339所定义的格式，格式为yyyy-MM-DDThh:mm:ss+TIMEZONE
     */
    @SerializedName("update_time")
    private String updateTime;

    public String getOutBillNo() {
        return outBillNo;
    }

    public void setOutBillNo(String outBillNo) {
        this.outBillNo = outBillNo;
    }

    public String getTransferBillNo() {
        return transferBillNo;
    }

    public void setTransferBillNo(String transferBillNo) {
        this.transferBillNo = transferBillNo;
    }


    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }


    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || getClass() != o.getClass()) return false;
        CancelBillsDetailResponse that = (CancelBillsDetailResponse) o;
        return Objects.equals(outBillNo, that.outBillNo) && Objects.equals(transferBillNo, that.transferBillNo) && Objects.equals(state, that.state) && Objects.equals(updateTime, that.updateTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(outBillNo, transferBillNo, state, updateTime);
    }
}

