/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.wechatpay.v3.service.impl;

import com.biz.crm.wechatpay.util.HttpServletUtil;
import com.biz.crm.wechatpay.v3.model.GetTransferBatchByNoRequest;
import com.biz.crm.wechatpay.v3.model.GetTransferBatchByOutNoRequest;
import com.biz.crm.wechatpay.v3.model.GetTransferDetailByNoRequest;
import com.biz.crm.wechatpay.v3.model.GetTransferDetailByOutNoRequest;
import com.biz.crm.wechatpay.v3.model.InitiateBatchTransferRequest;
import com.biz.crm.wechatpay.v3.model.InitiateBatchTransferResponse;
import com.biz.crm.wechatpay.v3.model.TransferBatchResponse;
import com.biz.crm.wechatpay.v3.model.TransferDetailResponse;
import com.biz.crm.wechatpay.v3.model.TransferNotifyDetailResponse;
import com.biz.crm.wechatpay.v3.service.WechatPayV3TransferBatchService;
import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.cipher.PrivacyDecryptor;
import com.wechat.pay.java.core.cipher.PrivacyEncryptor;
import com.wechat.pay.java.core.exception.ValidationException;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.http.UrlEncoder;
import com.wechat.pay.java.core.notification.NotificationConfig;
import com.wechat.pay.java.core.notification.NotificationParser;
import com.wechat.pay.java.core.notification.RequestParam;
import com.wechat.pay.java.core.util.GsonUtil;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;

public class WechatPayV3TransferBatchServiceImpl
implements WechatPayV3TransferBatchService {
    private static final String GET_TRANSFER_BATCH_BY_BATCH_ID_URL = "https://api.mch.weixin.qq.com/v3/transfer/batches/batch-id/%s";
    private static final String GET_TRANSFER_BATCH_BY_OUT_BATCH_NO_URL = "https://api.mch.weixin.qq.com/v3/transfer/batches/out-batch-no/%s";
    private static final String TRANSFER_BATCH_URL = "https://api.mch.weixin.qq.com/v3/transfer/batches";
    private static final String GET_DETAIL_BY_BATCH_ID_URL = "https://api.mch.weixin.qq.com/v3/transfer/batches/batch-id/%s/details/detail-id/%s";
    private static final String GET_DETAIL_BY_BATCH_NO_URL = "https://api.mch.weixin.qq.com/v3/transfer/batches/out-batch-no/%s/details/out-detail-no/%s";
    private final HttpClient httpClient;
    private final PrivacyEncryptor encryptor;
    private final PrivacyDecryptor decryptor;
    private final NotificationParser parser;

    private WechatPayV3TransferBatchServiceImpl(HttpClient httpClient, PrivacyEncryptor encryptor, PrivacyDecryptor decryptor, NotificationParser parser) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.encryptor = Objects.requireNonNull(encryptor);
        this.decryptor = Objects.requireNonNull(decryptor);
        this.parser = Objects.requireNonNull(parser);
    }

    @Override
    public TransferBatchResponse getTransferBatchByNo(GetTransferBatchByNoRequest realRequest) {
        String requestPath = String.format(GET_TRANSFER_BATCH_BY_BATCH_ID_URL, UrlEncoder.urlEncode((String)realRequest.getBatchId()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getNeedQueryDetail() != null) {
            queryParameter.add("need_query_detail", (Object)UrlEncoder.urlEncode((String)realRequest.getNeedQueryDetail().toString()));
        }
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        if (realRequest.getDetailStatus() != null && realRequest.getNeedQueryDetail().booleanValue()) {
            queryParameter.add("detail_status", (Object)UrlEncoder.urlEncode((String)realRequest.getDetailStatus()));
        }
        requestPath = requestPath.concat(queryParameter.getQueryStr());
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, TransferBatchResponse.class);
        return (TransferBatchResponse)httpResponse.getServiceResponse();
    }

    @Override
    public TransferBatchResponse getTransferBatchByOutNo(GetTransferBatchByOutNoRequest realRequest) {
        String requestPath = String.format(GET_TRANSFER_BATCH_BY_OUT_BATCH_NO_URL, UrlEncoder.urlEncode((String)realRequest.getOutBatchNo()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getNeedQueryDetail() != null) {
            queryParameter.add("need_query_detail", (Object)UrlEncoder.urlEncode((String)realRequest.getNeedQueryDetail().toString()));
        }
        if (realRequest.getOffset() != null) {
            queryParameter.add("offset", (Object)UrlEncoder.urlEncode((String)realRequest.getOffset().toString()));
        }
        if (realRequest.getLimit() != null) {
            queryParameter.add("limit", (Object)UrlEncoder.urlEncode((String)realRequest.getLimit().toString()));
        }
        if (realRequest.getDetailStatus() != null && realRequest.getNeedQueryDetail().booleanValue()) {
            queryParameter.add("detail_status", (Object)UrlEncoder.urlEncode((String)realRequest.getDetailStatus()));
        }
        requestPath = requestPath.concat(queryParameter.getQueryStr());
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, TransferBatchResponse.class);
        return (TransferBatchResponse)httpResponse.getServiceResponse();
    }

    @Override
    public InitiateBatchTransferResponse batchTransfer(InitiateBatchTransferRequest request) {
        InitiateBatchTransferRequest realRequest = request.cloneWithCipher(arg_0 -> ((PrivacyEncryptor)this.encryptor).encrypt(arg_0));
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Wechatpay-Serial", this.encryptor.getWechatpaySerial());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(TRANSFER_BATCH_URL).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, InitiateBatchTransferResponse.class);
        return (InitiateBatchTransferResponse)httpResponse.getServiceResponse();
    }

    private RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(GsonUtil.toJson((Object)request)).build();
    }

    @Override
    public TransferDetailResponse getTransferDetailByNo(GetTransferDetailByNoRequest request) {
        String requestPath = String.format(GET_DETAIL_BY_BATCH_ID_URL, UrlEncoder.urlEncode((String)request.getBatchId()), UrlEncoder.urlEncode((String)request.getDetailId()));
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, TransferDetailResponse.class);
        return ((TransferDetailResponse)httpResponse.getServiceResponse()).cloneWithCipher(arg_0 -> ((PrivacyDecryptor)this.decryptor).decrypt(arg_0));
    }

    @Override
    public TransferDetailResponse getTransferDetailByOutNo(GetTransferDetailByOutNoRequest request) {
        String requestPath = String.format(GET_DETAIL_BY_BATCH_NO_URL, UrlEncoder.urlEncode((String)request.getOutBatchNo()), UrlEncoder.urlEncode((String)request.getOutDetailNo()));
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, TransferDetailResponse.class);
        return ((TransferDetailResponse)httpResponse.getServiceResponse()).cloneWithCipher(arg_0 -> ((PrivacyDecryptor)this.decryptor).decrypt(arg_0));
    }

    @Override
    public TransferNotifyDetailResponse doNotify(HttpServletRequest request) {
        String requestBody = HttpServletUtil.getBodyString(request);
        Objects.requireNonNull(requestBody);
        RequestParam requestParam = new RequestParam.Builder().serialNumber(request.getHeader("Wechatpay-Serial")).nonce(request.getHeader("Wechatpay-Nonce")).signature(request.getHeader("Wechatpay-Signature")).timestamp(request.getHeader("Wechatpay-Timestamp")).body(requestBody).build();
        try {
            TransferNotifyDetailResponse response = (TransferNotifyDetailResponse)this.parser.parse(requestParam, TransferNotifyDetailResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new ValidationException("\u56de\u8c03\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static class Builder {
        private HttpClient httpClient;
        private PrivacyEncryptor encryptor;
        private PrivacyDecryptor decryptor;
        private NotificationParser parser;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            this.encryptor = config.createEncryptor();
            this.decryptor = config.createDecryptor();
            this.parser = new NotificationParser(new NotificationConfig[]{(NotificationConfig)config});
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder encryptor(PrivacyEncryptor encryptor) {
            this.encryptor = encryptor;
            return this;
        }

        public Builder decryptor(PrivacyDecryptor decryptor) {
            this.decryptor = decryptor;
            return this;
        }

        public Builder parser(NotificationParser parser) {
            this.parser = parser;
            return this;
        }

        public WechatPayV3TransferBatchService build() {
            return new WechatPayV3TransferBatchServiceImpl(this.httpClient, this.encryptor, this.decryptor, this.parser);
        }
    }
}

