package com.biz.crm.wechatpay.v3.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/**
 * 通过微信批次单号查询批次单请求对象
 */
public class GetTransferBatchByNoRequest {
    /**
     * 微信批次单号 必填
     * 说明：微信批次单号，微信商家转账系统返回的唯一标识
     */
    @SerializedName("batch_id")
    @Expose(serialize = false)
    private String batchId;

    /**
     * 是否查询转账明细单 必填
     * 说明：true-是；false-否，默认否。商户可选择是否查询指定状态的转账明细单，当转账批次单状态为“FINISHED”（已完成）时，才会返回满足条件的转账明细单
     */
    @SerializedName("need_query_detail")
    @Expose(serialize = false)
    private Boolean needQueryDetail = false;

    /**
     * 请求资源起始位置 选填
     * 说明：该次请求资源的起始位置。返回的明细是按照设置的明细条数进行分页展示的，一次查询可能无法返回所有明细，我们使用该参数标识查询开始位置，默认值为0
     */
    @SerializedName("offset")
    @Expose(serialize = false)
    private Integer offset = 0;

    /**
     * 最大资源条数 选填
     * 说明：该次请求可返回的最大明细条数，最小20条，最大100条，不传则默认20条。不足20条按实际条数返回
     */
    @SerializedName("limit")
    @Expose(serialize = false)
    private Integer limit = 20;

    /**
     * 明细状态 选填  当need_query_detail为true时该字段必填
     * 说明：WAIT_PAY: 待确认。待商户确认, 符合免密条件时, 系统会自动扭转为转账中
     * ALL:全部。需要同时查询转账成功、失败和待确认的明细单
     * SUCCESS:转账成功
     * FAIL:转账失败。需要确认失败原因后，再决定是否重新发起对该笔明细单的转账（并非整个转账批次单）
     */
    @SerializedName("detail_status")
    @Expose(serialize = false)
    private String detailStatus;

    public String getBatchId() {
        return batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public Boolean getNeedQueryDetail() {
        return needQueryDetail;
    }

    public void setNeedQueryDetail(Boolean needQueryDetail) {
        this.needQueryDetail = needQueryDetail;
    }

    public Integer getOffset() {
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getLimit() {
        return limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public String getDetailStatus() {
        return detailStatus;
    }

    public void setDetailStatus(String detailStatus) {
        this.detailStatus = detailStatus;
    }

}
