package com.biz.crm.wechatpay.v3.model;

import com.google.gson.annotations.SerializedName;
import com.wechat.pay.java.core.cipher.Encryption;

import java.util.function.UnaryOperator;

/**
 * 转账明细列表
 */
public class TransferDetailInput {
    /**
     * 商家明细单号 必填
     * 说明：商户系统内部区分转账批次单下不同转账明细单的唯一标识，要求此参数只能由数字、大小写字母组成
     */
    @SerializedName("out_detail_no")
    private String outDetailNo;

    /**
     * 转账金额 必填
     * 说明：转账金额单位为“分”
     */
    @SerializedName("transfer_amount")
    private Long transferAmount;

    /**
     * 转账备注 必填
     * 说明：单条转账备注（微信用户会收到该备注），UTF8编码，最多允许32个字符
     */
    @SerializedName("transfer_remark")
    private String transferRemark;

    /**
     * 收款用户openid 必填
     * 说明：商户appid下，某用户的openid
     */
    @SerializedName("openid")
    private String openid;

    /**
     * 收款用户姓名 选填
     * 说明：收款方真实姓名。支持标准RSA算法和国密算法，公钥由微信侧提供 明细转账金额<0.3元时，不允许填写收款用户姓名 明细转账金额 >=
     * 2,000元时，该笔明细必须填写收款用户姓名 同一批次转账明细中的姓名字段传入规则需保持一致，也即全部填写、或全部不填写
     * 若商户传入收款用户姓名，微信支付会校验用户openID与姓名是否一致，并提供电子回单
     */
    @Encryption
    @SerializedName("user_name")
    private String userName;

    public String getOutDetailNo() {
        return outDetailNo;
    }

    public void setOutDetailNo(String outDetailNo) {
        this.outDetailNo = outDetailNo;
    }

    public Long getTransferAmount() {
        return transferAmount;
    }

    public void setTransferAmount(Long transferAmount) {
        this.transferAmount = transferAmount;
    }

    public String getTransferRemark() {
        return transferRemark;
    }

    public void setTransferRemark(String transferRemark) {
        this.transferRemark = transferRemark;
    }

    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public TransferDetailInput cloneWithCipher(UnaryOperator<String> s) {
        TransferDetailInput copy = new TransferDetailInput();
        copy.outDetailNo = outDetailNo;
        copy.transferAmount = transferAmount;
        copy.transferRemark = transferRemark;
        copy.openid = openid;
        if (userName != null && !userName.isEmpty()) {
            copy.userName = s.apply(userName);
        }
        return copy;
    }
}
