package com.biz.crm.wechatpay.v3plus.service;

import com.biz.crm.wechatpay.v3plus.model.CancelBillsDetailResponse;
import com.biz.crm.wechatpay.v3plus.model.InitiateBillsTransferRequest;
import com.biz.crm.wechatpay.v3plus.model.InitiateBillsTransferResponse;
import com.biz.crm.wechatpay.v3plus.model.TransferBillsDetailResponse;

import javax.servlet.http.HttpServletRequest;

/**
 * 微信商户号商家转账V3新版本批量转账服务接口
 */
public interface WechatPayV3PlusTransferBatchService {

    /***
     * 发起批量转账
     * @param request 请求对象
     * @return 响应对象
     */
    InitiateBillsTransferResponse transferBills(InitiateBillsTransferRequest request);

    /***
     * 通过微信单号查询转账单
     * 只支持查询最近30天内的转账单，超过30天可以通过资金账单对账确认
     * @param transferBillNo 为微信批次单号
     * @return 转账结果信息
     */
    TransferBillsDetailResponse getTransferBillsByNo(String transferBillNo);


    /***
     * 通过商户单号查询转账单
     * 只支持查询最近30天内的转账单，超过30天可以通过资金账单对账确认
     * @param outBillNo 为商户批次单号
     * @return 转账结果信息
     */
    TransferBillsDetailResponse getTransferBillsByOutNo(String outBillNo);

    /***
     * 撤销转账
     * 商户通过转账接口发起付款后，在用户确认收款之前可以通过该接口撤销付款。该接口返回成功仅表示撤销请求已受理，系统会异步处理退款等操作，以最终查询单据返回状态为准。
     * @param outBillNo  为商户批次单号
     * @return 撤销转账结果
     */
    CancelBillsDetailResponse cancelTransferBills(String outBillNo);

    /**
     * 打款回调接口处理逻辑
     * @param request 请求对象
     * @return 转账结果信息
     *         若遇ValidationException 表示校验不通过
     */
    TransferBillsDetailResponse doNotify(HttpServletRequest request);
}
