/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.wechatpay.v3plus.service.impl;

import com.biz.crm.wechatpay.util.HttpServletUtil;
import com.biz.crm.wechatpay.v3plus.model.CancelBillsDetailResponse;
import com.biz.crm.wechatpay.v3plus.model.InitiateBillsTransferRequest;
import com.biz.crm.wechatpay.v3plus.model.InitiateBillsTransferResponse;
import com.biz.crm.wechatpay.v3plus.model.TransferBillsDetailResponse;
import com.biz.crm.wechatpay.v3plus.service.WechatPayV3PlusTransferBatchService;
import com.google.gson.Gson;
import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.cipher.PrivacyDecryptor;
import com.wechat.pay.java.core.cipher.PrivacyEncryptor;
import com.wechat.pay.java.core.exception.ValidationException;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.http.UrlEncoder;
import com.wechat.pay.java.core.notification.NotificationConfig;
import com.wechat.pay.java.core.notification.NotificationParser;
import com.wechat.pay.java.core.notification.RequestParam;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;

public class WechatPayV3PlusTransferBatchServiceImpl
implements WechatPayV3PlusTransferBatchService {
    private static final String GET_TRANSFER_BATCH_BY_BATCH_ID_NEW_URL = "https://api.mch.weixin.qq.com/v3/fund-app/mch-transfer/transfer-bills/transfer-bill-no/%s";
    private static final String GET_TRANSFER_BATCH_BY_OUT_BATCH_NO_NEW_URL = "https://api.mch.weixin.qq.com/v3/fund-app/mch-transfer/transfer-bills/out-bill-no/%s";
    private static final String TRANSFER_BATCH_NEW_URL = "https://api.mch.weixin.qq.com/v3/fund-app/mch-transfer/transfer-bills";
    private static final String TRANSFER_BATCH_CANCEL_NEW_URL = "https://api.mch.weixin.qq.com/v3/fund-app/mch-transfer/transfer-bills/out-bill-no/%s/cancel";
    private final HttpClient httpClient;
    private final PrivacyEncryptor encryptor;
    private final PrivacyDecryptor decryptor;
    private final NotificationParser parser;

    private WechatPayV3PlusTransferBatchServiceImpl(HttpClient httpClient, PrivacyEncryptor encryptor, PrivacyDecryptor decryptor, NotificationParser parser) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.encryptor = Objects.requireNonNull(encryptor);
        this.decryptor = Objects.requireNonNull(decryptor);
        this.parser = Objects.requireNonNull(parser);
    }

    @Override
    public InitiateBillsTransferResponse transferBills(InitiateBillsTransferRequest request) {
        if (request.getUserName() != null && !"".equals(request.getUserName())) {
            String encryptName = this.encryptor.encrypt(request.getUserName());
            request.setUserName(encryptName);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Wechatpay-Serial", this.encryptor.getWechatpaySerial());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(TRANSFER_BATCH_NEW_URL).headers(headers).body(WechatPayV3PlusTransferBatchServiceImpl.createRequestBody(request)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, InitiateBillsTransferResponse.class);
        return (InitiateBillsTransferResponse)httpResponse.getServiceResponse();
    }

    private static RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(new Gson().toJson(request)).build();
    }

    @Override
    public TransferBillsDetailResponse getTransferBillsByNo(String transferBillNo) {
        String requestPath = String.format(GET_TRANSFER_BATCH_BY_BATCH_ID_NEW_URL, UrlEncoder.urlEncode((String)transferBillNo));
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, TransferBillsDetailResponse.class);
        return ((TransferBillsDetailResponse)httpResponse.getServiceResponse()).cloneWithCipher(this.decryptor);
    }

    @Override
    public TransferBillsDetailResponse getTransferBillsByOutNo(String outBillNo) {
        String requestPath = String.format(GET_TRANSFER_BATCH_BY_OUT_BATCH_NO_NEW_URL, UrlEncoder.urlEncode((String)outBillNo));
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, TransferBillsDetailResponse.class);
        return ((TransferBillsDetailResponse)httpResponse.getServiceResponse()).cloneWithCipher(this.decryptor);
    }

    @Override
    public CancelBillsDetailResponse cancelTransferBills(String outBillNo) {
        String requestPath = String.format(TRANSFER_BATCH_CANCEL_NEW_URL, UrlEncoder.urlEncode((String)outBillNo));
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, CancelBillsDetailResponse.class);
        return (CancelBillsDetailResponse)httpResponse.getServiceResponse();
    }

    @Override
    public TransferBillsDetailResponse doNotify(HttpServletRequest request) {
        String requestBody = HttpServletUtil.getBodyString(request);
        Objects.requireNonNull(requestBody);
        RequestParam requestParam = new RequestParam.Builder().serialNumber(request.getHeader("Wechatpay-Serial")).nonce(request.getHeader("Wechatpay-Nonce")).signature(request.getHeader("Wechatpay-Signature")).timestamp(request.getHeader("Wechatpay-Timestamp")).body(requestBody).build();
        try {
            TransferBillsDetailResponse response = (TransferBillsDetailResponse)this.parser.parse(requestParam, TransferBillsDetailResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new ValidationException("\u56de\u8c03\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static class Builder {
        private HttpClient httpClient;
        private PrivacyEncryptor encryptor;
        private PrivacyDecryptor decryptor;
        private NotificationParser parser;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            this.encryptor = config.createEncryptor();
            this.decryptor = config.createDecryptor();
            this.parser = new NotificationParser(new NotificationConfig[]{(NotificationConfig)config});
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder encryptor(PrivacyEncryptor encryptor) {
            this.encryptor = encryptor;
            return this;
        }

        public Builder decryptor(PrivacyDecryptor decryptor) {
            this.decryptor = decryptor;
            return this;
        }

        public Builder parser(NotificationParser parser) {
            this.parser = parser;
            return this;
        }

        public WechatPayV3PlusTransferBatchService build() {
            return new WechatPayV3PlusTransferBatchServiceImpl(this.httpClient, this.encryptor, this.decryptor, this.parser);
        }
    }
}

