package com.biz.crm.wechatpay.util;

import cn.hutool.core.io.IoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class HttpServletUtil {
    private HttpServletUtil(){}
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpServletUtil.class);

    /**
     * 获取post请求中的Body
     *
     * @param request httpRequest
     * @param charSet 字符集编码
     * @return body字符串
     */
    public static String getBodyString(HttpServletRequest request, String charSet) {
        StringBuilder sb = new StringBuilder();
        InputStream inputStream = null;
        BufferedReader reader = null;
        try {
            inputStream = request.getInputStream();
            //读取流并将流写出去,避免数据流中断;
            reader = new BufferedReader(new InputStreamReader(inputStream, charSet));
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        } catch (IOException e) {
           LOGGER.error("获取body字符串失败", e);
        } finally {
            IoUtil.close(inputStream);
            IoUtil.close(reader);
        }
        return sb.toString();
    }

    /**
     * 获取post请求中的Body
     * @param request httpRequest
     * @return body字符串
     */
    public static String getBodyString(HttpServletRequest request ) {
        return getBodyString(request, "UTF-8");
    }
}
