package com.biz.crm.wechatpay.v3.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/**
 * 通过微信明细单号查询明细单请求对象
 */
public class GetTransferDetailByNoRequest {
    /**
     * 微信批次单号 必填
     * 说明：微信批次单号，微信商家转账系统返回的唯一标识
     */
    @SerializedName("batch_id")
    @Expose(serialize = false)
    private String batchId;

    /**
     * 微信明细单号 必填
     * 说明：微信支付系统内部区分转账批次单下不同转账明细单的唯一标识
     */
    @SerializedName("detail_id")
    @Expose(serialize = false)
    private String detailId;

    public String getBatchId() {
        return batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getDetailId() {
        return detailId;
    }

    public void setDetailId(String detailId) {
        this.detailId = detailId;
    }

}
