package com.biz.crm.wechatpay.v3.model;

import com.google.gson.annotations.SerializedName;

import java.util.List;

/**
 * 转账结果查询信息
 */
public class TransferBatchResponse {
    /**
     * 转账批次单 必填
     * 说明：转账批次单基本信息
     */
    @SerializedName("transfer_batch")
    private TransferBatchGet transferBatch;

    /**
     * 转账明细单列表 选填
     * 说明：当批次状态为“FINISHED”（已完成），且成功查询到转账明细单时返回。包括微信明细单号、明细状态信息
     */
    @SerializedName("transfer_detail_list")
    private List<TransferDetailCompact> transferDetailList;

    public TransferBatchGet getTransferBatch() {
        return transferBatch;
    }

    public void setTransferBatch(TransferBatchGet transferBatch) {
        this.transferBatch = transferBatch;
    }

    public List<TransferDetailCompact> getTransferDetailList() {
        return transferDetailList;
    }

    public void setTransferDetailList(List<TransferDetailCompact> transferDetailList) {
        this.transferDetailList = transferDetailList;
    }
}
