/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.workflow.local.service.ProcessDefinitionService;
import org.flowable.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1//process/definition"})
public class ProcessDefinitionController {
    private static final Logger log = LoggerFactory.getLogger(ProcessDefinitionController.class);
    @Autowired
    private ProcessDefinitionService processDefinitionService;

    @PostMapping(value={"/activate"})
    public Result<?> activate(@RequestParam String key) {
        try {
            this.processDefinitionService.activate(key);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/activateById"})
    public Result<?> activateById(@RequestParam String processDefinitionId) {
        try {
            this.processDefinitionService.activateById(processDefinitionId);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/findByKey"})
    public Result<?> findByKey(@RequestParam String key) {
        try {
            ProcessDefinition processDefinition = this.processDefinitionService.findByKey(key);
            return Result.ok((Object)processDefinition);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

