/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.workflow.local.service.ProcessDeploymentService;
import java.util.List;
import org.flowable.engine.repository.Deployment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/process/deployment"})
public class ProcessDeploymentController {
    private static final Logger log = LoggerFactory.getLogger(ProcessDeploymentController.class);
    @Autowired
    private ProcessDeploymentService processDeploymentService;

    @PostMapping(value={"/create"})
    public Result<?> create(@RequestBody String xml) {
        try {
            Deployment deployment = this.processDeploymentService.create(xml);
            return Result.ok((Object)deployment);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/{id}"})
    public Result<?> findById(@PathVariable String id) {
        try {
            Deployment deployment = this.processDeploymentService.findById(id);
            return Result.ok((Object)deployment);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/findAll"})
    public Result<?> findAll() {
        try {
            List<Deployment> deployments = this.processDeploymentService.findAll();
            return Result.ok(deployments);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/deleteById"})
    public Result<?> deleteById(@RequestParam(value="id") String id) {
        try {
            this.processDeploymentService.delete(id);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

