/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.workflow.local.dto.ProcessInterveneDto;
import com.biz.crm.workflow.local.dto.ProcessInterventionDto;
import com.biz.crm.workflow.local.service.ProcessInstanceService;
import com.biz.crm.workflow.local.service.ProcessService;
import com.biz.crm.workflow.local.vo.ProcessInterventionVo;
import com.biz.crm.workflow.sdk.dto.ProcessInstanceDto;
import com.biz.crm.workflow.sdk.dto.TaskDto;
import com.biz.crm.workflow.sdk.vo.ProcessInstanceVo;
import com.biz.crm.workflow.sdk.vo.ProcessTaskVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.Validate;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.engine.HistoryService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricActivityInstanceQuery;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.image.ProcessDiagramGenerator;
import org.flowable.task.api.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/process/instance"})
@Api(tags={"\u6d41\u7a0b\u5b9e\u4f8b: ProcessInstance"})
public class ProcessInstanceController {
    private static final Logger log = LoggerFactory.getLogger(ProcessInstanceController.class);
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessService processService;

    @PostMapping(value={"/startWithKey"})
    public Result<?> startWithKey(@RequestParam(value="key") String key) {
        try {
            ProcessInstance instance = this.processInstanceService.startWithKey(key);
            log.debug("start:{}", (Object)instance.toString());
            return Result.ok((String)instance.getProcessInstanceId());
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/startProcess"})
    @ApiOperation(value="\u53d1\u8d77\u6d41\u7a0b\u7ed3\u679c")
    public Result<ProcessInstanceVo> startProcess(@RequestBody ProcessInstanceDto dto) {
        try {
            return Result.ok((Object)this.processInstanceService.startProcess(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/deleteById"})
    public Result<?> deleteById(@RequestParam(value="id") String id) {
        try {
            this.processInstanceService.deleteById(id);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/findByConditions"})
    public Result<?> findByConditions(Pageable pageable, String userCode) {
        try {
            Page<ProcessInstance> page = this.processInstanceService.findByConditions(pageable, userCode);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"/enableBatch"})
    @ApiOperation(value="\u6279\u91cf\u542f\u7528\u6d41\u7a0b\u5b9e\u4f8b")
    public Result<?> enableBatch(@RequestBody List<String> ids) {
        this.processInstanceService.enableBatch(ids);
        return Result.ok();
    }

    @PatchMapping(value={"/disableBatch"})
    @ApiOperation(value="\u6279\u91cf\u7981\u7528\u6d41\u7a0b\u5b9e\u4f8b")
    public Result<?> disableBatch(@RequestBody List<String> ids) {
        this.processInstanceService.disableBatch(ids);
        return Result.ok();
    }

    @PatchMapping(value={"/closeProcessInstance"})
    @ApiOperation(value="\u6d41\u7a0b\u5173\u95ed")
    public Result<?> disableBatch(@RequestBody String processInstanceId) {
        this.processInstanceService.closeProcessInstance(processInstanceId);
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bid\u67e5\u8be2\u5f53\u524d\u5f85\u529e\u4efb\u52a1\u8282\u70b9")
    @GetMapping(value={"/getOptList"})
    public Result<List<ProcessTaskVo>> getOptList(@RequestParam(value="processInstanceId") String processInstanceId) {
        return Result.ok(this.processInstanceService.getRunTasks(processInstanceId));
    }

    @PostMapping(value={"/processDelegate"})
    @ApiOperation(value="\u6d41\u7a0b\u59d4\u6d3e")
    public Result<?> processDelegate(@RequestBody TaskDto taskDto) {
        Validate.notNull((Object)taskDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)taskDto.getTaskId(), (String)"\u7f16\u53f7\u4efb\u52a1\u4e3a\u7a7a,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notNull((Object)taskDto.getTargetUserName(), (String)"\u76ee\u6807\u8d26\u53f7\u4e3a\u7a7a,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        this.processService.delegateTask(taskDto);
        return Result.ok();
    }

    @PostMapping(value={"/processIntervene"})
    @ApiOperation(value="\u6d41\u7a0b\u5e72\u9884")
    public Result<?> processIntervene(@RequestBody ProcessInterveneDto processInterveneDto) {
        Validate.notNull((Object)((Object)processInterveneDto), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)processInterveneDto.getTaskId(), (String)"\u7f16\u53f7\u4efb\u52a1\u4e3a\u7a7a,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notNull((Object)processInterveneDto.getProcessInstanceId(), (String)"\u6d41\u7a0b\u5b9e\u4f8bid\u4e3a\u7a7a,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(processInterveneDto.getApprovedUsers()) ? 1 : 0) != 0, (String)"\u76ee\u6807\u8d26\u53f7\u4e3a\u7a7a,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)processInterveneDto.getTaskKey(), (String)"\u5e72\u9884\u76ee\u6807\u8282\u70b9\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        this.processService.processIntervene(processInterveneDto);
        return Result.ok();
    }

    @GetMapping(value={"/getBpmnChart"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8b\u83b7\u53d6\u6d41\u7a0b\u56fe")
    public void getBpmnChart(HttpServletResponse response, String processInstanceId) {
        BpmnModel bpmnModel = this.processInstanceService.findBpmnModelByProcessInstanceId(processInstanceId);
        ProcessEngineConfiguration processEngineConfiguration = this.processEngine.getProcessEngineConfiguration();
        ProcessDiagramGenerator diagramGenerator = processEngineConfiguration.getProcessDiagramGenerator();
        ArrayList activityIds = Lists.newArrayList();
        ArrayList flows = Lists.newArrayList();
        List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityTenantId(TenantUtils.getTenantCode()).orderByHistoricActivityInstanceStartTime().asc()).list();
        historicActivityInstances.forEach(hi -> {
            String activityType = hi.getActivityType();
            if (activityType.equals("sequenceFlow") || activityType.equals("exclusiveGateway")) {
                flows.add(hi.getActivityId());
            } else if (activityType.equals("userTask") || activityType.equals("startEvent")) {
                activityIds.add(hi.getActivityId());
            }
        });
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).taskTenantId(TenantUtils.getTenantCode())).list();
        tasks.forEach(task -> activityIds.add(task.getTaskDefinitionKey()));
        try (InputStream in = diagramGenerator.generateDiagram(bpmnModel, "png", (List)activityIds, (List)flows, processEngineConfiguration.getActivityFontName(), processEngineConfiguration.getLabelFontName(), processEngineConfiguration.getAnnotationFontName(), processEngineConfiguration.getClassLoader(), 1.0, false);
             ServletOutputStream out = response.getOutputStream();){
            response.setContentType("image/png");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            byte[] buf = new byte[1024];
            int length = 0;
            while ((length = in.read(buf)) != -1) {
                out.write(buf, 0, length);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u5b9e\u4f8bid\u67e5\u8be2\u6d41\u7a0b\u53ef\u5e72\u9884\u8282\u70b9")
    @GetMapping(value={"/findInterventionNodesByProcessInstanceId"})
    public Result<List<ProcessInterventionVo>> findInterventionNodesByProcessInstanceId(@ApiParam(name="processInstanceId", value="\u6d41\u7a0b\u5b9e\u4f8bid") String processInstanceId) {
        try {
            List<ProcessInterventionVo> result = this.processInstanceService.findInterventionNodesByProcessInstanceId(processInstanceId);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d41\u7a0b\u5e72\u9884")
    @PostMapping(value={"/processIntervention"})
    public Result<?> processIntervention(@RequestBody ProcessInterventionDto processInterventionDto) {
        try {
            this.processInstanceService.processIntervention(processInterventionDto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

