/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.workflow.local.service.ProcessInstanceFilesService;
import com.biz.crm.workflow.sdk.vo.ProcessInstanceFilesVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/process/instance/files"})
@Api(tags={"\u6d41\u7a0b\u5b9e\u4f8b: ProcessInstanceFiles"})
public class ProcessInstanceFilesController {
    private static final Logger log = LoggerFactory.getLogger(ProcessInstanceFilesController.class);
    @Autowired
    private ProcessInstanceFilesService processInstanceFilesService;

    @GetMapping(value={"/findByProcessInstanceId"})
    public Result<?> findByProcessInstanceId(String processInstanceId) {
        try {
            List<ProcessInstanceFilesVo> processInstanceFilesVos = this.processInstanceFilesService.findByProcessInstanceId(processInstanceId);
            return Result.ok(processInstanceFilesVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    public Result<?> delete(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="idList") List<String> idList) {
        try {
            this.processInstanceFilesService.delete(idList);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

