/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.workflow.local.service.ProcessTaskButtonService;
import com.biz.crm.workflow.sdk.dto.ProcessTaskButtonDto;
import com.biz.crm.workflow.sdk.vo.ProcessTaskButtonVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u4efb\u52a1\u6309\u94ae\u529f\u80fd\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/v1/ProcessTaskButtonEntity"})
public class ProcessTaskButtonController {
    private static final Logger log = LoggerFactory.getLogger(ProcessTaskButtonController.class);
    @Autowired
    private ProcessTaskButtonService processTaskButtonService;

    @ApiOperation(value="\u901a\u8fc7\u4efb\u52a1\u8282\u70b9id\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"findByNodeId"})
    public Result<List<ProcessTaskButtonVo>> findByNodeId(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid", required=true) String nodeId) {
        try {
            List<ProcessTaskButtonVo> processTaskButtonVo = this.processTaskButtonService.findByNodeId(nodeId);
            return Result.ok(processTaskButtonVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<ProcessTaskButtonVo> create(@ApiParam(name="processTaskButtonDto", value="\u6d41\u7a0b\u4efb\u52a1\u6309\u94ae") @RequestBody ProcessTaskButtonDto processTaskButtonDto) {
        try {
            ProcessTaskButtonVo result = this.processTaskButtonService.create(processTaskButtonDto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    public Result<?> delete(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="idList") List<String> idList) {
        try {
            this.processTaskButtonService.delete(idList);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u6d41\u7a0b\u5b9e\u4f8bid\u67e5\u8be2\u6309\u94ae\u6570\u636e")
    @GetMapping(value={"findByProcessInstanceId"})
    public Result<List<ProcessTaskButtonVo>> findByProcessInstanceId(@RequestParam(value="processInstanceId") String processInstanceId) {
        try {
            List<ProcessTaskButtonVo> processTaskButtonVo = this.processTaskButtonService.findByProcessInstanceId(processInstanceId);
            return Result.ok(processTaskButtonVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

