/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.workflow.local.service.ProcessTaskService;
import com.biz.crm.workflow.sdk.dto.ProcessTaskListDto;
import com.biz.crm.workflow.sdk.dto.TaskDto;
import com.biz.crm.workflow.sdk.vo.ProcessTaskListVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.flowable.task.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/process/task"})
public class ProcessTaskController {
    private static final Logger log = LoggerFactory.getLogger(ProcessTaskController.class);
    @Autowired
    private ProcessTaskService processTaskService;

    @PostMapping(value={"/handleTask"})
    public Result<?> handleTask(@RequestBody TaskDto taskDto) {
        try {
            this.processTaskService.handleTask(taskDto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/handleTaskRetrieve"})
    public Result<?> handleTaskRetrieve(@RequestBody TaskDto taskDto) {
        try {
            this.processTaskService.handleTaskRetrieve(taskDto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/handleTaskRecover"})
    public Result<?> handleTaskRecover(@RequestBody TaskDto taskDto) {
        try {
            this.processTaskService.handleTaskRecover(taskDto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/updateFormData"})
    public Result<?> updateFormData(@RequestBody TaskDto taskDto) {
        try {
            this.processTaskService.updateFormData(taskDto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/findByInstanceId"})
    public Result<?> findByInstanceId(@RequestParam(value="instanceId") String instanceId) {
        try {
            List<Task> tasks = this.processTaskService.findByInstanceId(instanceId);
            log.debug("start:{}", (Object)tasks.toString());
            return Result.ok(tasks);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/findByProcessDefinitionKey"})
    public Result<?> findByProcessDefinitionKey(@RequestParam(value="key") String key) {
        try {
            List<Task> tasks = this.processTaskService.findByProcessDefinitionKey(key);
            log.debug("start:{}", (Object)tasks.toString());
            return Result.ok(tasks);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/findTodoListByConditions"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5f85\u529e\u5217\u8868")
    public Result<Page<ProcessTaskListVo>> findTodoListByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="processTaskListDto", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") ProcessTaskListDto dto) {
        try {
            Page<ProcessTaskListVo> page = this.processTaskService.findTodoListByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/findCompleteListByConditions"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5df2\u529e\u5217\u8868")
    public Result<Page<ProcessTaskListVo>> findCompleteListByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="processTaskListDto", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") ProcessTaskListDto dto) {
        try {
            Page<ProcessTaskListVo> page = this.processTaskService.findCompleteListByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/findCommitListByConditions"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5df2\u53d1\u5217\u8868")
    public Result<Page<ProcessTaskListVo>> findCommitListByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="processTaskListDto", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") ProcessTaskListDto dto) {
        try {
            Page<ProcessTaskListVo> page = this.processTaskService.findCommitListByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

