/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.workflow.local.dto.ProcessTaskLogDto;
import com.biz.crm.workflow.local.service.ProcessTaskLogService;
import com.biz.crm.workflow.local.vo.ProcessTaskLogVo;
import com.biz.crm.workflow.sdk.vo.ProcessLogsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u4efb\u52a1\u65e5\u5fd7\u529f\u80fd\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/v1/processTaskLog"})
public class ProcessTaskLogController {
    private static final Logger log = LoggerFactory.getLogger(ProcessTaskLogController.class);
    @Autowired
    private ProcessTaskLogService processTaskLogService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<ProcessTaskLogVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="processTaskLog", value="\u6838\u9500\u91c7\u96c6\u4fe1\u606f") ProcessTaskLogDto dto) {
        try {
            Page<ProcessTaskLogVo> page = this.processTaskLogService.findByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7f16\u53f7\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"findByProcessInstanceId"})
    public Result<List<ProcessLogsVo>> findByProcessInstanceId(@RequestParam(value="processInstanceId") String processInstanceId) {
        try {
            List<ProcessLogsVo> processTaskLogVo = this.processTaskLogService.findByProcessInstanceId(processInstanceId);
            return Result.ok(processTaskLogVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7f16\u53f7\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"findByFormNo"})
    public Result<List<ProcessLogsVo>> findByFormNo(@RequestParam(value="formNo") String formNo) {
        try {
            List<ProcessLogsVo> processTaskLogVo = this.processTaskLogService.findByFormNo(formNo);
            return Result.ok(processTaskLogVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7f16\u53f7\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"findByProcessNo"})
    public Result<List<ProcessLogsVo>> findByProcessNo(@RequestParam(value="processNo") String processNo) {
        try {
            List<ProcessLogsVo> processTaskLogVo = this.processTaskLogService.findByProcessNo(processNo);
            return Result.ok(processTaskLogVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<ProcessTaskLogVo> create(@ApiParam(name="processTaskLogDto", value="\u6d41\u7a0b\u4efb\u52a1\u65e5\u5fd7") @RequestBody ProcessTaskLogDto processTaskLogDto) {
        try {
            ProcessTaskLogVo result = this.processTaskLogService.create(processTaskLogDto);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

