/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.workflow.local.entity.ProcessTemplate;
import com.biz.crm.workflow.local.service.ProcessTemplateService;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateDto;
import com.biz.crm.workflow.sdk.dto.ProcessTemplatePageDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/process/processTemplate"})
@Api(tags={"\u6d41\u7a0b\u7ed8\u5236: ProcessTemplate: \u6d41\u7a0b\u7ed8\u5236"})
public class ProcessTemplateController {
    private static final Logger log = LoggerFactory.getLogger(ProcessTemplateController.class);
    @Autowired
    private ProcessTemplateService processTemplateService;

    @ApiOperation(value="\u6d41\u7a0b\u7ba1\u7406\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<ProcessTemplate>> findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="ProcessTemplatePageDto", value="\u5206\u9875Dto") ProcessTemplatePageDto dto) {
        try {
            return Result.ok(this.processTemplateService.findByConditions(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d41\u7a0b\u65b0\u589e")
    @PostMapping
    public Result<ProcessTemplate> create(@RequestBody ProcessTemplateDto dto) {
        try {
            return Result.ok((Object)((Object)this.processTemplateService.create(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d41\u7a0b\u7f16\u8f91")
    @PatchMapping
    public Result<ProcessTemplate> update(@RequestBody ProcessTemplateDto dto) {
        try {
            return Result.ok((Object)((Object)this.processTemplateService.update(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result deleteBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            this.processTemplateService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d41\u7a0b\u7ba1\u7406\u767b\u5f55\u4eba\u9002\u7528\u7684\u6d41\u7a0b\u5206\u9875\u4fe1\u606f")
    @GetMapping(value={"/findByLoginDetailConditions"})
    public Result<Page<ProcessTemplate>> findByLoginDetailConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="ProcessTemplatePageDto", value="\u5206\u9875Dto") ProcessTemplatePageDto dto) {
        try {
            return Result.ok(this.processTemplateService.findByLoginDetailConditions(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d41\u7a0b\u7ba1\u7406\u767b\u5f55\u4eba\u9002\u7528\u7684\u6d41\u7a0b\u4e0d\u5206\u9875")
    @GetMapping(value={"/findListByLoginDetailConditions"})
    public Result<List<ProcessTemplate>> findListByLoginDetailConditions(@ApiParam(name="ProcessTemplatePageDto", value="\u5206\u9875Dto") ProcessTemplatePageDto dto) {
        try {
            return Result.ok(this.processTemplateService.findListByLoginDetailConditions(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u5386\u53f2\u7248\u672c\u5217\u8868")
    @GetMapping(value={"/findByProcessKey"})
    public Result<List<ProcessTemplate>> findByProcessKey(@ApiParam(name="processKey", value="\u6d41\u7a0bkey") String processKey) {
        try {
            return Result.ok(this.processTemplateService.findByProcessKey(processKey));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4f7f\u7528\u8be5\u7248\u672c")
    @PatchMapping(value={"/release"})
    public Result release(@RequestParam(value="id") String id) {
        try {
            this.processTemplateService.releaseVersion(id);
            return Result.ok((String)"\u53d1\u5e03\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u53d1\u5e03")
    @PostMapping(value={"/publishBatch"})
    public Result publishBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            this.processTemplateService.publish(ids);
            return Result.ok((String)"\u53d1\u5e03\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

