/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.workflow.local.vo.ApplicationUserScopeVo;
import com.biz.crm.workflow.local.vo.ProcessButtonVo;
import com.biz.crm.workflow.local.vo.ProcessDelegateTypeVo;
import com.biz.crm.workflow.local.vo.ProcessExtensionFieldVo;
import com.biz.crm.workflow.local.vo.ProcessIndicatorVo;
import com.biz.crm.workflow.local.vo.ProcessNodeGroupVo;
import com.biz.crm.workflow.local.vo.ProcessNodeVo;
import com.biz.crm.workflow.local.vo.SmsToUserVo;
import com.biz.crm.workflow.local.vo.TracingVo;
import com.biz.crm.workflow.sdk.enums.EffectiveScopeEnum;
import com.biz.crm.workflow.sdk.register.ProcessTemplateRegister;
import com.biz.crm.workflow.sdk.service.process.ProcessNodeGroup;
import com.biz.crm.workflow.sdk.strategy.button.ProcessButtonStrategy;
import com.biz.crm.workflow.sdk.strategy.delegatetype.ProcessDelegateMandataryTypeStrategy;
import com.biz.crm.workflow.sdk.strategy.delegatetype.ProcessDelegateTypeStrategy;
import com.biz.crm.workflow.sdk.strategy.extensionfield.ProcessExtensionFieldStrategy;
import com.biz.crm.workflow.sdk.strategy.indicator.ProcessIndicatorStrategy;
import com.biz.crm.workflow.sdk.strategy.scope.ApplicationUserScopeStrategy;
import com.biz.crm.workflow.sdk.strategy.sms.SmsToUserStrategy;
import com.biz.crm.workflow.sdk.strategy.tracing.TracingStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1//process/register"})
@Api(tags={"\u6d41\u7a0b\u6a21\u677f\u6ce8\u518c\u4fe1\u606f"})
public class ProcessTemplateRegisterController {
    private static final Logger log = LoggerFactory.getLogger(ProcessTemplateRegisterController.class);
    @Autowired
    private ProcessTemplateRegister processTemplateRegister;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ApplicationContext ac;

    @GetMapping(value={"/findNodeGroups"})
    @ApiOperation(value="\u83b7\u53d6\u6a21\u677f\u8282\u70b9\u5206\u7ec4\u4fe1\u606f")
    public Result<?> findNodeGroups(@RequestParam(value="processNodeType") String processNodeType) {
        try {
            Collection processNodeGroups = this.processTemplateRegister.getProcessNodeGroups();
            ArrayList nodeGroupVos = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)processNodeGroups)) {
                processNodeGroups.forEach(clazz -> {
                    ProcessNodeGroup processNodeGroup = (ProcessNodeGroup)this.ac.getBean(clazz);
                    ProcessNodeGroupVo processNodeGroupVo = (ProcessNodeGroupVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processNodeGroup, ProcessNodeGroupVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"processNodes"});
                    if (!CollectionUtils.isEmpty(processNodeGroupVo.getProcessNodes()) && !EffectiveScopeEnum.ALL.getDictCode().equals(processNodeType)) {
                        List<ProcessNodeVo> processNodeVos = processNodeGroupVo.getProcessNodes().stream().filter(processNodeVo -> processNodeVo.getProcessNodeType().equals(processNodeType) || processNodeVo.getProcessNodeType().equals(EffectiveScopeEnum.ALL.getDictCode())).collect(Collectors.toList());
                        processNodeGroupVo.setProcessNodes(processNodeVos);
                    }
                    nodeGroupVos.add(processNodeGroupVo);
                });
            }
            List<Object> nodeGroupVoList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)nodeGroupVos)) {
                nodeGroupVoList = !EffectiveScopeEnum.ALL.getDictCode().equals(processNodeType) ? nodeGroupVos.stream().filter(processNodeVo -> processNodeVo.getProcessNodeType().equals(processNodeType) || processNodeVo.getProcessNodeType().equals(EffectiveScopeEnum.ALL.getDictCode())).collect(Collectors.toList()) : nodeGroupVos;
            }
            return Result.ok(nodeGroupVoList);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/findTracings"})
    @ApiOperation(value="\u83b7\u53d6\u5bfb\u4eba\u7b56\u7565\u4fe1\u606f")
    public Result<?> findTracings() {
        try {
            Collection tracingStrategies = this.processTemplateRegister.getTracingStrategies();
            ArrayList strategies = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)tracingStrategies)) {
                tracingStrategies.forEach(clazz -> {
                    TracingStrategy tracingStrategy = (TracingStrategy)this.ac.getBean(clazz);
                    TracingVo tracingVo = (TracingVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)tracingStrategy, TracingVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    strategies.add(tracingVo);
                });
            }
            return Result.ok((Object)strategies);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u6309\u94ae")
    @GetMapping(value={"/findProcessButton"})
    public Result<?> findProcessButton(@RequestParam(value="buttonType") String buttonType) {
        try {
            Collection processButtonStrategies = this.processTemplateRegister.getProcessButtonStrategies();
            ArrayList strategies = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)processButtonStrategies)) {
                processButtonStrategies.forEach(clazz -> {
                    ProcessButtonStrategy processButtonRegister = (ProcessButtonStrategy)this.ac.getBean(clazz);
                    ProcessButtonVo processButtonVo = (ProcessButtonVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processButtonRegister, ProcessButtonVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    if (EffectiveScopeEnum.ALL.getDictCode().equals(buttonType)) {
                        strategies.add(processButtonVo);
                    } else if (processButtonVo.getProcessButtonType().equals(EffectiveScopeEnum.ALL.getDictCode()) || processButtonVo.getProcessButtonType().equals(buttonType)) {
                        strategies.add(processButtonVo);
                    }
                });
            }
            return Result.ok((Object)strategies);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u6d41\u7a0b\u6309\u94ae")
    @GetMapping(value={"/findAllProcessButton"})
    public Result<?> findAllProcessButton() {
        try {
            Collection processButtonStrategies = this.processTemplateRegister.getProcessButtonStrategies();
            ArrayList strategies = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)processButtonStrategies)) {
                processButtonStrategies.forEach(clazz -> {
                    ProcessButtonStrategy processButtonRegister = (ProcessButtonStrategy)this.ac.getBean(clazz);
                    ProcessButtonVo processButtonVo = (ProcessButtonVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processButtonRegister, ProcessButtonVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    strategies.add(processButtonVo);
                });
            }
            return Result.ok((Object)strategies);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d41\u7a0b\u9002\u7528\u8303\u56f4")
    @GetMapping(value={"/findProcessUserScope"})
    public Result<List<ApplicationUserScopeVo>> findProcessUserScope() {
        try {
            Collection applicationUserScopeStrategies = this.processTemplateRegister.getApplicationUserScopeStrategies();
            ArrayList strategies = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)applicationUserScopeStrategies)) {
                applicationUserScopeStrategies.forEach(clazz -> {
                    ApplicationUserScopeStrategy applicationUserScopeStrategy = (ApplicationUserScopeStrategy)this.ac.getBean(clazz);
                    ApplicationUserScopeVo applicationUserScopeVo = (ApplicationUserScopeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)applicationUserScopeStrategy, ApplicationUserScopeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    strategies.add(applicationUserScopeVo);
                });
            }
            return Result.ok((Object)strategies);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u83dc\u5355\u7f16\u7801\u67e5\u8be2\u6d41\u7a0b\u6307\u6807")
    @GetMapping(value={"/findProcessIndicatorByFunctionSubCode"})
    public Result<?> findProcessIndicatorByFunctionSubCode(String functionSubCode) {
        try {
            Collection processIndicatorStrategies = this.processTemplateRegister.getProcessIndicatorStrategies();
            ArrayList strategies = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)processIndicatorStrategies)) {
                processIndicatorStrategies.forEach(clazz -> {
                    ProcessIndicatorStrategy processIndicatorStrategy = (ProcessIndicatorStrategy)this.ac.getBean(clazz);
                    if (processIndicatorStrategy.getFunctionSubCode().equals(functionSubCode)) {
                        ProcessIndicatorVo processIndicatorVo = (ProcessIndicatorVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processIndicatorStrategy, ProcessIndicatorVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                        strategies.add(processIndicatorVo);
                    }
                });
            }
            return Result.ok((Object)strategies);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d41\u7a0b\u8282\u70b9\u6536\u4ef6\u4eba\u7b56\u7565")
    @GetMapping(value={"/findSmsToUserType"})
    public Result<?> findSmsToUserType() {
        try {
            Collection smsToUserStrategies = this.processTemplateRegister.getSmsToUserStrategies();
            ArrayList strategies = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)smsToUserStrategies)) {
                smsToUserStrategies.forEach(clazz -> {
                    SmsToUserStrategy smsToUserStrategy = (SmsToUserStrategy)this.ac.getBean(clazz);
                    SmsToUserVo smsToUserVo = (SmsToUserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)smsToUserStrategy, SmsToUserVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    strategies.add(smsToUserVo);
                });
            }
            return Result.ok((Object)strategies);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u83dc\u5355\u7f16\u7801\u67e5\u8be2\u6d41\u7a0b\u6269\u5c55\u5b57\u6bb5")
    @GetMapping(value={"/findProcessExtensionFieldByFunctionSubCode"})
    public Result<?> findProcessExtensionFieldByFunctionSubCode(@RequestParam(value="functionCode") String functionCode, @RequestParam(value="parentCode") String parentCode) {
        try {
            Collection processIndicatorStrategies = this.processTemplateRegister.getProcessExtensionFieldStrategies();
            ArrayList strategies = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)processIndicatorStrategies)) {
                processIndicatorStrategies.forEach(clazz -> {
                    ProcessExtensionFieldStrategy processExtensionFieldStrategy = (ProcessExtensionFieldStrategy)this.ac.getBean(clazz);
                    if (processExtensionFieldStrategy.getFunctionCode().equals(functionCode) && processExtensionFieldStrategy.getParentCode().equals(parentCode)) {
                        ProcessExtensionFieldVo processExtensionFieldVo = (ProcessExtensionFieldVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processExtensionFieldStrategy, ProcessExtensionFieldVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                        strategies.add(processExtensionFieldVo);
                    }
                });
            }
            return Result.ok((Object)strategies);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d41\u7a0b\u914d\u7f6e\u59d4\u6258\u4eba\u5bfb\u4eba\u7b56\u7565")
    @GetMapping(value={"/findProcessDelegateType"})
    public Result<?> findProcessDelegateType() {
        try {
            Collection processDelegateTypeStrategies = this.processTemplateRegister.getProcessDelegateTypeStrategies();
            ArrayList strategies = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)processDelegateTypeStrategies)) {
                processDelegateTypeStrategies.forEach(clazz -> {
                    ProcessDelegateTypeStrategy processDelegateTypeStrategy = (ProcessDelegateTypeStrategy)this.ac.getBean(clazz);
                    ProcessDelegateTypeVo processDelegateTypeVo = (ProcessDelegateTypeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processDelegateTypeStrategy, ProcessDelegateTypeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    strategies.add(processDelegateTypeVo);
                });
            }
            return Result.ok((Object)strategies);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d41\u7a0b\u914d\u7f6e\u88ab\u59d4\u6258\u4eba\u5bfb\u4eba\u7b56\u7565")
    @GetMapping(value={"/findProcessDelegateMandataryType"})
    public Result<?> findProcessDelegateMandataryType() {
        try {
            Collection processDelegateTypeStrategies = this.processTemplateRegister.getProcessDelegateMandataryTypeStrategies();
            ArrayList strategies = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)processDelegateTypeStrategies)) {
                processDelegateTypeStrategies.forEach(clazz -> {
                    ProcessDelegateMandataryTypeStrategy processDelegateTypeStrategy = (ProcessDelegateMandataryTypeStrategy)this.ac.getBean(clazz);
                    ProcessDelegateTypeVo processDelegateTypeVo = (ProcessDelegateTypeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)processDelegateTypeStrategy, ProcessDelegateTypeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    strategies.add(processDelegateTypeVo);
                });
            }
            return Result.ok((Object)strategies);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

