/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.notifier;

import com.biz.crm.workflow.sdk.listener.ExecutionEndListener;
import com.biz.crm.workflow.sdk.listener.ExecutionStartListener;
import com.biz.crm.workflow.sdk.listener.ExecutionTakeListener;
import java.util.List;
import javax.transaction.Transactional;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="defaultExecutionListener")
public class DefaultExecutionListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultExecutionListener.class);
    @Autowired(required=false)
    private List<ExecutionStartListener> executionStartListeners;
    @Autowired(required=false)
    private List<ExecutionTakeListener> executionTakeListeners;
    @Autowired(required=false)
    private List<ExecutionEndListener> executionEndListeners;

    @Transactional
    public void notify(DelegateExecution delegateExecution) {
        String eventName = delegateExecution.getEventName();
        String taskId = delegateExecution.getId();
        log.debug("\u8282\u70b9id:{},\u4e8b\u4ef6{}", (Object)delegateExecution.getCurrentActivityId(), (Object)delegateExecution.getEventName());
        if ("start".equals(eventName)) {
            log.debug("{}\u4e8b\u4ef6\u6267\u884c\u4e86 [{}]", (Object)eventName, (Object)taskId);
            if (!CollectionUtils.isEmpty(this.executionStartListeners)) {
                this.executionStartListeners.forEach(listener -> listener.notify(delegateExecution));
            }
        } else if ("end".equals(eventName)) {
            log.debug("{}\u4e8b\u4ef6\u6267\u884c\u4e86 [{}]", (Object)eventName, (Object)taskId);
            if (!CollectionUtils.isEmpty(this.executionEndListeners)) {
                this.executionEndListeners.forEach(listener -> listener.notify(delegateExecution));
            }
        } else if ("take".equals(eventName)) {
            log.debug("{}\u4e8b\u4ef6\u6267\u884c\u4e86 [{}]", (Object)eventName, (Object)taskId);
            if (!CollectionUtils.isEmpty(this.executionTakeListeners)) {
                this.executionTakeListeners.forEach(listener -> listener.notify(delegateExecution));
            }
        }
    }
}

