/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.notifier;

import com.biz.crm.workflow.sdk.listener.TaskAssignmentListener;
import com.biz.crm.workflow.sdk.listener.TaskCompleteListener;
import com.biz.crm.workflow.sdk.listener.TaskCreateListener;
import com.biz.crm.workflow.sdk.listener.TaskDeleteListener;
import java.util.List;
import javax.transaction.Transactional;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="defaultTaskListener")
public class DefaultTaskListener
implements TaskListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultTaskListener.class);
    @Autowired(required=false)
    private List<TaskCreateListener> taskCreateListeners;
    @Autowired(required=false)
    private List<TaskAssignmentListener> taskAssignmentListeners;
    @Autowired(required=false)
    private List<TaskCompleteListener> taskCompleteListeners;
    @Autowired(required=false)
    private List<TaskDeleteListener> taskDeleteListeners;

    @Transactional
    public void notify(DelegateTask delegateTask) {
        String taskId = delegateTask.getId();
        String eventName = delegateTask.getEventName();
        log.debug("\u8282\u70b9:{},\u4e8b\u4ef6{}", (Object)delegateTask.getName(), (Object)delegateTask.getEventName());
        if ("create".endsWith(eventName)) {
            log.debug("\u521b\u5efa\uff1acreate [{}]", (Object)taskId);
            if (!CollectionUtils.isEmpty(this.taskCreateListeners)) {
                this.taskCreateListeners.forEach(listener -> listener.notify(delegateTask));
            }
        } else if ("assignment".endsWith(eventName)) {
            log.debug("\u6307\u6d3e\uff1aassignment [{}]", (Object)taskId);
            if (!CollectionUtils.isEmpty(this.taskAssignmentListeners)) {
                this.taskAssignmentListeners.forEach(listener -> listener.notify(delegateTask));
            }
        } else if ("complete".endsWith(eventName)) {
            log.debug("\u5b8c\u6210\uff1acomplete [{}]", (Object)taskId);
            if (!CollectionUtils.isEmpty(this.taskCompleteListeners)) {
                this.taskCompleteListeners.forEach(listener -> listener.notify(delegateTask));
            }
        } else if ("delete".endsWith(eventName)) {
            log.debug("\u9500\u6bc1\uff1adelete [{}]", (Object)taskId);
            if (!CollectionUtils.isEmpty(this.taskDeleteListeners)) {
                this.taskDeleteListeners.forEach(listener -> listener.notify(delegateTask));
            }
        } else {
            log.error("\u672a\u5339\u914d\u7684\u4efb\u52a1\u7c7b\u578b{},\u8bf7\u68c0\u67e5", (Object)eventName);
        }
    }
}

