/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.notifier;

import com.biz.crm.workflow.local.service.ProcessPreExecutionService;
import com.biz.crm.workflow.local.service.ProcessTaskCopyService;
import com.biz.crm.workflow.sdk.dto.TaskDto;
import com.biz.crm.workflow.sdk.listener.ExecutionEndListener;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.engine.delegate.DelegateExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EndTaskListener
implements ExecutionEndListener {
    private static final Logger log = LoggerFactory.getLogger(EndTaskListener.class);
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private ProcessTaskCopyService processTaskCopyService;
    @Autowired
    private ProcessPreExecutionService processPreExecutionService;

    @Transactional
    public void notify(DelegateExecution delegateExecution) {
        FlowElement currentFlowElement = delegateExecution.getCurrentFlowElement();
        if (!(currentFlowElement instanceof StartEvent)) {
            ProcessTemplateNodeVo processTemplateNodeVo = this.processTemplateNodeService.findByProcessInstanceIdAndTaskDefinitionKey(delegateExecution.getProcessInstanceId(), delegateExecution.getCurrentActivityId());
            if (Objects.isNull(processTemplateNodeVo)) {
                processTemplateNodeVo = this.processTemplateNodeService.findByProcessDefinitionIdAndTaskDefinitionKey(delegateExecution.getProcessDefinitionId(), delegateExecution.getCurrentActivityId());
            }
            Validate.notNull((Object)processTemplateNodeVo, (String)"\u4efb\u52a1\u8282\u70b9\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            TaskDto dto = new TaskDto();
            dto.setProcessInstanceId(delegateExecution.getProcessInstanceId());
            dto.setTaskDefinitionKey(delegateExecution.getCurrentActivityId());
            dto.setExecutionId(delegateExecution.getId());
            this.processTaskCopyService.createByTask(dto);
            String taskDefinitionKey = dto.getTaskDefinitionKey();
            String processInstanceId = dto.getProcessInstanceId();
            this.processPreExecutionService.updatePreLogByProcessInstanceId(processInstanceId, taskDefinitionKey);
        }
    }
}

