/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.notifier;

import com.alibaba.fastjson.JSON;
import com.biz.crm.workflow.local.entity.ProcessInstanceEntity;
import com.biz.crm.workflow.local.service.ProcessInstanceService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeUserTaskService;
import com.biz.crm.workflow.local.service.process.node.task.UserTaskProcessNode;
import com.biz.crm.workflow.sdk.constant.ProcessConstant;
import com.biz.crm.workflow.sdk.dto.FormDataEventDto;
import com.biz.crm.workflow.sdk.listener.ProcessInstanceFormDataEventListener;
import com.biz.crm.workflow.sdk.listener.TaskCompleteListener;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.service.process.ProcessNode;
import com.biz.crm.workflow.sdk.strategy.extensionfield.ProcessExtensionFieldStrategy;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeUserTaskVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.biz.crm.workflow.sdk.vo.response.ProcessInstanceFormDataResponse;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.engine.TaskService;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class FormDataListener
implements TaskCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(FormDataListener.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private ProcessTemplateNodeUserTaskService processTemplateNodeUserTaskService;
    @Autowired(required=false)
    private List<ProcessNode> processNodes;
    @Autowired
    private List<ProcessExtensionFieldStrategy> processExtensionFieldStrategies;

    public void notify(DelegateTask delegateTask) {
        ProcessInstanceEntity processInstanceEntity;
        String code;
        ProcessNode processNode;
        String taskId = delegateTask.getId();
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskTenantId(TenantUtils.getTenantCode())).taskId(taskId)).singleResult();
        ProcessTemplateNodeVo processTemplateNodeVo = this.processTemplateNodeService.findByProcessInstanceIdAndTaskDefinitionKey(task.getProcessInstanceId(), task.getTaskDefinitionKey());
        if (Objects.isNull(processTemplateNodeVo)) {
            processTemplateNodeVo = this.processTemplateNodeService.findByProcessDefinitionIdAndTaskDefinitionKey(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        }
        if ((processNode = this.findCurrentProcessNode(code = processTemplateNodeVo.getCode())) == null) {
            log.error("\u672a\u5339\u914d\u7684\u6d41\u7a0b\u8282\u70b9\u5904\u7406\u7f16\u53f7[{}],\u8bf7\u68c0\u67e5\u6d41\u7a0b\u6a21\u677f\u6ce8\u518c\u5668", (Object)code);
            return;
        }
        if (!(processNode instanceof UserTaskProcessNode)) {
            return;
        }
        ProcessTemplateNodeUserTaskVo processTemplateNodeUserTaskVo = this.processTemplateNodeUserTaskService.findByNodeId(processTemplateNodeVo.getId());
        boolean canEdit = BooleanUtils.isTrue((Boolean)processTemplateNodeUserTaskVo.getCanEdit());
        if (canEdit && (processInstanceEntity = this.processInstanceService.findByProcessInstanceId(task.getProcessInstanceId())) != null) {
            SerializableBiConsumer & Serializable sf = ProcessInstanceFormDataEventListener::getFormData;
            FormDataEventDto formDataEventDto = FormDataEventDto.builder().tenantCode(TenantUtils.getTenantCode()).processNo(processInstanceEntity.getProcessNo()).processKey(processInstanceEntity.getProcessKey()).businessNo(processInstanceEntity.getBusinessFormNo()).businessCode(processInstanceEntity.getBusinessCode()).build();
            ProcessInstanceFormDataResponse response = (ProcessInstanceFormDataResponse)this.nebulaNetEventClient.publishToApplication((NebulaEventDto)formDataEventDto, ProcessInstanceFormDataEventListener.class, (SerializableBiConsumer)sf);
            if (response != null) {
                List eventResponses = response.getEventResponses();
                String formDataJson = (String)eventResponses.get(0);
                this.taskService.setVariable(task.getId(), ProcessConstant.PROCESS_INSTANCE_FORM_DATA_CODE, (Object)formDataJson);
            }
        }
    }

    private ProcessNode findCurrentProcessNode(String code) {
        if (CollectionUtils.isEmpty(this.processNodes)) {
            return null;
        }
        return this.processNodes.stream().filter(item -> item.getCode().equals(code)).findFirst().orElse(null);
    }

    public int getOrder() {
        return 100;
    }

    private void validateExtensionField(ProcessInstanceFormDataResponse processBusinessDto) {
        Validate.notNull((Object)processBusinessDto, (String)"\u6d41\u7a0b\u5ba1\u6279\u901a\u8fc7\u65f6\uff0c\u56de\u8c03\u4e1a\u52a1\u53c2\u6570\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(this.processExtensionFieldStrategies)) {
            Validate.notNull((Object)processBusinessDto.getBusinessCode(), (String)"\u6d41\u7a0b\u5ba1\u6279\u901a\u8fc7\u65f6\uff0c\u4e1a\u52a1\u7f16\u53f7\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            List<ProcessExtensionFieldStrategy> strategies = this.processExtensionFieldStrategies.stream().filter(processExtensionFieldStrategy -> processExtensionFieldStrategy.getFunctionCode().equals(processBusinessDto.getBusinessCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(strategies)) {
                Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)processBusinessDto.getEventResponses()), (String)"\u6d41\u7a0b\u5ba1\u6279\u901a\u8fc7\u65f6\uff0c\u4e1a\u52a1\u7aef\u67e5\u8be2\u5230\u6269\u5c55\u5b57\u6bb5\u7684\u4e1a\u52a1\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                List eventResponses = processBusinessDto.getEventResponses();
                HashMap params = Maps.newHashMap();
                params.put(ProcessConstant.PROCESS_INSTANCE_FORM_DATA_CODE, JSON.parseObject((String)((String)eventResponses.get(0))));
                strategies.forEach(processExtensionFieldStrategy -> processExtensionFieldStrategy.onValidate(params));
            }
        }
    }
}

