/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.notifier;

import com.biz.crm.workflow.client.listener.ProcessStatusListener;
import com.biz.crm.workflow.local.entity.ProcessInstanceEntity;
import com.biz.crm.workflow.local.repository.ProcessInstanceRepository;
import com.biz.crm.workflow.sdk.constant.ProcessConstant;
import com.biz.crm.workflow.sdk.dto.ProcessInstanceDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEntityEvent;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.delegate.event.AbstractFlowableEngineEventListener;
import org.flowable.engine.delegate.event.FlowableCancelledEvent;
import org.flowable.engine.delegate.event.impl.FlowableEntityEventImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.flowable.engine.runtime.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GlobalProcessListenerEndListener
extends AbstractFlowableEngineEventListener {
    private static final Logger log = LoggerFactory.getLogger(GlobalProcessListenerEndListener.class);
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private ProcessInstanceRepository processInstanceRepository;
    @Autowired
    private RuntimeService runtimeService;

    @Transactional
    protected void processCancelled(FlowableCancelledEvent event) {
        log.debug("\u76d1\u542c\u6d41\u7a0b\u5220\u9664\uff0c\u6d41\u7a0b\u5b9e\u4f8b\u7f16\u53f7\uff1a{}", (Object)event.getProcessInstanceId());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceTenantId(TenantUtils.getTenantCode()).processInstanceId(event.getProcessInstanceId()).singleResult();
        Validate.notNull((Object)processInstance, (String)"\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u7ecf\u5220\u9664\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String operate = (String)processInstance.getProcessVariables().get(ProcessConstant.PROCESS_INSTANCE_OPERATE_CODE);
        if (StringUtils.isBlank((CharSequence)operate)) {
            log.warn("\u672a\u8fdb\u884c\u901a\u77e5\u7684\u6d41\u7a0b\u5173\u95ed\u52a8\u4f5c,\u6d41\u7a0b\u5b9e\u4f8b\u7f16\u53f7\uff1a{}", (Object)event.getProcessInstanceId());
            return;
        }
        String processInstanceId = processInstance.getProcessInstanceId();
        ProcessInstanceDto processInstanceDto = (ProcessInstanceDto)processInstance.getProcessVariables().get(ProcessConstant.PROCESS_INSTANCE_PARAM_CODE);
        Validate.notNull((Object)processInstanceDto, (String)"\u5168\u5c40\u9ed8\u8ba4\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ProcessInstanceEntity processInstanceEntity = this.processInstanceRepository.findByInstanceId(processInstanceId);
        Validate.notNull((Object)((Object)processInstanceEntity), (String)"\u8be5\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728\u6d41\u7a0b\u5b9e\u4f8bid[%s]\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{processInstanceId});
        ProcessStatusDto processStatusDto = new ProcessStatusDto();
        processStatusDto.setProcessNo(processInstanceEntity.getProcessNo());
        processStatusDto.setProcessTitle(processInstanceDto.getProcessTitle());
        processStatusDto.setBusinessNo(processInstanceDto.getBusinessFormNo());
        processStatusDto.setApplicationName(processInstanceDto.getApplicationName());
        processStatusDto.setBusinessCode(processInstanceDto.getBusinessCode());
        processStatusDto.setProcessKey(processInstanceDto.getProcessKey());
        processStatusDto.setProcessStatus(operate);
        processStatusDto.setTenantCode(processInstanceEntity.getTenantCode());
        try {
            SerializableBiConsumer & Serializable sf = ProcessStatusListener::onProcessStatusChanged;
            this.nebulaNetEventClient.publish((NebulaEventDto)processStatusDto, ProcessStatusListener.class, (SerializableBiConsumer)sf);
            processInstanceEntity.setProcessStatus(operate);
            this.processInstanceRepository.updateById((Object)processInstanceEntity);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Transactional
    protected void processCompleted(FlowableEngineEntityEvent event) {
        log.debug("\u76d1\u542c\u6d41\u7a0b\u7ed3\u675f\uff0c\u6d41\u7a0b\u5b9e\u4f8b\u7f16\u53f7\uff1a{}", (Object)event.getProcessInstanceId());
        FlowableEntityEventImpl flowableEntityEvent = (FlowableEntityEventImpl)event;
        ExecutionEntityImpl processInstance = (ExecutionEntityImpl)flowableEntityEvent.getEntity();
        String operate = (String)processInstance.getVariable(ProcessConstant.PROCESS_INSTANCE_OPERATE_CODE);
        if (StringUtils.isBlank((CharSequence)operate)) {
            log.warn("\u672a\u8fdb\u884c\u901a\u77e5\u7684\u6d41\u7a0b\u5173\u95ed\u52a8\u4f5c,\u6d41\u7a0b\u5b9e\u4f8b\u7f16\u53f7\uff1a{},\u4e8b\u4ef6\u540d\u79f0:{}", (Object)event.getProcessInstanceId(), (Object)processInstance.getEventName());
            return;
        }
        ProcessInstanceDto processInstanceDto = (ProcessInstanceDto)processInstance.getVariable(ProcessConstant.PROCESS_INSTANCE_PARAM_CODE);
        Validate.notNull((Object)processInstanceDto, (String)"\u5168\u5c40\u9ed8\u8ba4\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        HashSet processStatusSet = Sets.newHashSet((Object[])new String[]{ProcessStatusEnum.START.getDictCode(), ProcessStatusEnum.COMMIT.getDictCode()});
        ProcessInstanceEntity processInstanceEntity = this.processInstanceRepository.findByBusinessNoAndIncludeStatus(processInstanceDto.getBusinessFormNo(), processStatusSet);
        if (processInstanceEntity == null) {
            log.error("\u4f60\u64cd\u4f5c\u7684\u901f\u5ea6\u592a\u5feb\u4e86\uff0c\u6d41\u7a0b\u5b9e\u4f8b\u8fd8\u6ca1\u751f\u6210\uff01\uff01\uff01");
            return;
        }
        ProcessStatusDto processStatusDto = new ProcessStatusDto();
        processStatusDto.setProcessNo(processInstanceEntity.getProcessNo());
        processStatusDto.setProcessTitle(processInstanceDto.getProcessTitle());
        processStatusDto.setBusinessNo(processInstanceDto.getBusinessFormNo());
        processStatusDto.setApplicationName(processInstanceDto.getApplicationName());
        processStatusDto.setBusinessCode(processInstanceDto.getBusinessCode());
        processStatusDto.setProcessKey(processInstanceDto.getProcessKey());
        processStatusDto.setProcessStatus(operate);
        processStatusDto.setTenantCode(processInstanceEntity.getTenantCode());
        try {
            SerializableBiConsumer & Serializable sf = ProcessStatusListener::onProcessStatusChanged;
            this.nebulaNetEventClient.publish((NebulaEventDto)processStatusDto, ProcessStatusListener.class, (SerializableBiConsumer)sf);
            processInstanceEntity.setProcessStatus(operate);
            this.processInstanceRepository.updateById((Object)processInstanceEntity);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

