/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.notifier;

import com.biz.crm.workflow.local.service.ProcessTaskService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeUserTaskService;
import com.biz.crm.workflow.local.service.process.node.task.UserTaskProcessNode;
import com.biz.crm.workflow.sdk.constant.ProcessConstant;
import com.biz.crm.workflow.sdk.listener.ExecutionStartListener;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.service.process.ProcessNode;
import com.biz.crm.workflow.sdk.strategy.tracing.TracingStrategy;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeUserTaskVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.engine.TaskService;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MultiUserTaskStartListener
implements ExecutionStartListener {
    private static final Logger log = LoggerFactory.getLogger(MultiUserTaskStartListener.class);
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private ProcessTemplateNodeUserTaskService processTemplateNodeUserTaskService;
    @Autowired
    private ProcessTaskService processTaskService;
    @Autowired
    private TaskService taskService;
    @Autowired(required=false)
    private List<ProcessNode> processNodes;
    @Autowired(required=false)
    private List<TracingStrategy> tracingStrategies;

    @Transactional
    public void notify(DelegateExecution delegateExecution) {
        ProcessTemplateNodeUserTaskVo processTemplateNodeUserTaskVo;
        String signType;
        log.debug("\u4f1a\u7b7e\u7528\u6237\u4efb\u52a1\u8282\u70b9\u76d1\u542c");
        FlowElement flowElement = delegateExecution.getCurrentFlowElement();
        String taskId = delegateExecution.getCurrentActivityId();
        String varKey = String.format("_%s_%s", "countersigns", taskId);
        ProcessTemplateNodeVo processTemplateNodeVo = this.processTemplateNodeService.findByProcessInstanceIdAndTaskDefinitionKey(delegateExecution.getProcessInstanceId(), taskId);
        if (Objects.isNull(processTemplateNodeVo)) {
            processTemplateNodeVo = this.processTemplateNodeService.findByProcessDefinitionIdAndTaskDefinitionKey(delegateExecution.getProcessDefinitionId(), taskId);
        }
        Validate.notNull((Object)processTemplateNodeVo, (String)"\u6d41\u7a0b\u8282\u70b9\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        ProcessNode processNode = this.findCurrentProcessNode(processTemplateNodeVo.getCode());
        if (processNode instanceof UserTaskProcessNode && ProcessConstant.PROCESS_SIGN_TYPE_MULTI.equals(signType = (processTemplateNodeUserTaskVo = this.processTemplateNodeUserTaskService.findByNodeId(processTemplateNodeVo.getId())).getSignType())) {
            Set assigneeCodes = new HashSet();
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(delegateExecution.getProcessInstanceId())).list();
            List taskIds = tasks.stream().map(TaskInfo::getId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty((Collection)tasks)) {
                assigneeCodes = (Set)this.processTaskService.findAssigneesByTaskNodeIdAndTaskId(processTemplateNodeVo.getId(), taskId, delegateExecution.getProcessInstanceId(), processTemplateNodeVo.getProcessTaskId(), null);
            } else {
                HashSet interventions = new HashSet();
                for (String id : taskIds) {
                    Set intervention = (Set)this.taskService.getVariablesLocal(id).get("_Intervention");
                    if (CollectionUtils.isEmpty((Collection)intervention)) continue;
                    interventions.addAll(intervention);
                }
                if (!CollectionUtils.isEmpty(interventions)) {
                    assigneeCodes = interventions;
                }
            }
            if (CollectionUtils.isEmpty(assigneeCodes)) {
                Object params = delegateExecution.getVariable(varKey);
                if (params != null) {
                    return;
                }
                assigneeCodes = (Set)this.processTaskService.findAssigneesByTaskNodeIdAndTaskId(processTemplateNodeVo.getId(), (String)taskIds.get(0), delegateExecution.getProcessInstanceId(), processTemplateNodeVo.getProcessTaskId(), null);
            }
            Validate.notEmpty(assigneeCodes, (String)"\u8282\u70b9[%s]\u5ba1\u6279\u4eba\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{flowElement.getName()});
            long count = assigneeCodes.stream().filter(StringUtils::isNotBlank).count();
            Validate.isTrue((count > 0L ? 1 : 0) != 0, (String)"\u8282\u70b9[%s]\u5ba1\u6279\u4eba\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{flowElement.getName()});
            if (!CollectionUtils.isEmpty(assigneeCodes)) {
                log.debug("\u4f1a\u7b7e\u7528\u6237\u4efb\u52a1\u8282\u70b9\u8bbe\u7f6e\u4f1a\u7b7e\u4eba\uff1a{}", (Object)assigneeCodes.size());
                delegateExecution.setVariable(varKey, assigneeCodes);
            }
        }
    }

    private ProcessNode findCurrentProcessNode(String code) {
        if (CollectionUtils.isEmpty(this.processNodes)) {
            return null;
        }
        return this.processNodes.stream().filter(item -> item.getCode().equals(code)).findFirst().orElse(null);
    }
}

