/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.notifier;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.workflow.client.listener.ProcessStatusListener;
import com.biz.crm.workflow.local.dto.ProcessTaskLogDto;
import com.biz.crm.workflow.local.entity.ProcessInstanceEntity;
import com.biz.crm.workflow.local.service.ProcessDelegateConfigService;
import com.biz.crm.workflow.local.service.ProcessInstanceService;
import com.biz.crm.workflow.local.service.ProcessTaskLogService;
import com.biz.crm.workflow.local.service.ProcessTaskService;
import com.biz.crm.workflow.local.service.ProcessTemplateNodeUserTaskService;
import com.biz.crm.workflow.local.service.TaskMultiCacheVoService;
import com.biz.crm.workflow.local.service.process.node.task.UserTaskProcessNode;
import com.biz.crm.workflow.sdk.constant.ProcessConstant;
import com.biz.crm.workflow.sdk.dto.ProcessDelegateCopyDto;
import com.biz.crm.workflow.sdk.dto.ProcessInstanceDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.dto.ProcessUserDto;
import com.biz.crm.workflow.sdk.enums.ProcessOperateTypeEnum;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.TaskCreateListener;
import com.biz.crm.workflow.sdk.service.ProcessTemplateNodeService;
import com.biz.crm.workflow.sdk.service.process.ProcessNode;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeUserTaskVo;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.biz.crm.workflow.sdk.vo.WorkflowUserIdentity;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class NodeAssigneeListener
implements TaskCreateListener {
    private static final Logger log = LoggerFactory.getLogger(NodeAssigneeListener.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private ProcessTaskService processTaskService;
    @Autowired
    private ProcessTemplateNodeService processTemplateNodeService;
    @Autowired
    private ProcessTemplateNodeUserTaskService processTemplateNodeUserTaskService;
    @Autowired(required=false)
    private List<ProcessNode> processNodes;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private ProcessDelegateConfigService processDelegateConfigService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private TaskMultiCacheVoService taskMultiCacheVoService;
    @Autowired
    private ProcessTaskLogService processTaskLogService;

    @Transactional
    public void notify(DelegateTask delegateTask) {
        String taskId = delegateTask.getId();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(delegateTask.getProcessInstanceId())).list();
        if (!CollectionUtils.isEmpty((Collection)tasks)) {
            List taskIds = tasks.stream().map(TaskInfo::getId).distinct().collect(Collectors.toList());
            HashSet interventions = new HashSet();
            for (String id : taskIds) {
                Set intervention2 = (Set)this.taskService.getVariablesLocal(id).get("_Intervention");
                if (Objects.isNull(intervention2)) continue;
                interventions.addAll(intervention2);
            }
            if (CollectionUtils.isEmpty(interventions)) {
                this.nodeNotify(taskId);
            } else {
                String code;
                ProcessNode processNode;
                ProcessTemplateNodeVo processTemplateNodeVo = this.processTemplateNodeService.findByProcessInstanceIdAndTaskDefinitionKey(delegateTask.getProcessInstanceId(), delegateTask.getTaskDefinitionKey());
                if (Objects.isNull(processTemplateNodeVo)) {
                    processTemplateNodeVo = this.processTemplateNodeService.findByProcessDefinitionIdAndTaskDefinitionKey(delegateTask.getProcessDefinitionId(), delegateTask.getTaskDefinitionKey());
                }
                if ((processNode = this.findCurrentProcessNode(code = processTemplateNodeVo.getCode())) == null) {
                    log.error("\u672a\u5339\u914d\u7684\u6d41\u7a0b\u8282\u70b9\u5904\u7406\u7f16\u53f7[{}],\u8bf7\u68c0\u67e5\u6d41\u7a0b\u6a21\u677f\u6ce8\u518c\u5668", (Object)code);
                    return;
                }
                if (!(processNode instanceof UserTaskProcessNode)) {
                    return;
                }
                ProcessTemplateNodeUserTaskVo processTemplateNodeUserTaskVo = this.processTemplateNodeUserTaskService.findByNodeId(processTemplateNodeVo.getId());
                List<String> interventionList = interventions.stream().distinct().collect(Collectors.toList());
                if (ProcessConstant.PROCESS_SIGN_TYPE_MULTI.equals(processTemplateNodeUserTaskVo.getSignType())) {
                    ArrayList<String> cAssigness = new ArrayList<String>();
                    List<String> oldAssignees = this.taskMultiCacheVoService.get(delegateTask.getProcessInstanceId() + ":" + delegateTask.getTaskDefinitionKey() + "_Intervention");
                    if (!CollectionUtils.isEmpty(oldAssignees)) {
                        List newAssigneeCodes = interventionList.stream().filter(s -> !oldAssignees.contains(s)).collect(Collectors.toList());
                        this.taskService.addCandidateUser(delegateTask.getId(), (String)newAssigneeCodes.get(0));
                        cAssigness.add((String)newAssigneeCodes.get(0));
                        cAssigness.addAll(oldAssignees);
                        this.taskMultiCacheVoService.set(delegateTask.getProcessInstanceId() + ":" + delegateTask.getTaskDefinitionKey() + "_Intervention", cAssigness);
                    } else {
                        String next = (String)interventionList.stream().iterator().next();
                        this.taskService.addCandidateUser(delegateTask.getId(), next);
                        this.taskMultiCacheVoService.set(delegateTask.getProcessInstanceId() + ":" + delegateTask.getTaskDefinitionKey() + "_Intervention", Collections.singletonList(next));
                    }
                } else {
                    interventionList.forEach(intervention -> this.taskService.addCandidateUser(taskId, intervention));
                    this.taskMultiCacheVoService.set(delegateTask.getProcessInstanceId() + ":" + delegateTask.getTaskDefinitionKey() + "_Intervention", interventionList);
                }
            }
        } else {
            this.nodeNotify(taskId);
        }
    }

    private void nodeNotify(String taskId) {
        Set<Object> userCodes;
        String code;
        ProcessNode processNode;
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskTenantId(TenantUtils.getTenantCode())).taskId(taskId)).includeProcessVariables()).singleResult();
        ProcessTemplateNodeVo processTemplateNodeVo = this.processTemplateNodeService.findByProcessInstanceIdAndTaskDefinitionKey(task.getProcessInstanceId(), task.getTaskDefinitionKey());
        if (Objects.isNull(processTemplateNodeVo)) {
            processTemplateNodeVo = this.processTemplateNodeService.findByProcessDefinitionIdAndTaskDefinitionKey(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        }
        if ((processNode = this.findCurrentProcessNode(code = processTemplateNodeVo.getCode())) == null) {
            log.error("\u672a\u5339\u914d\u7684\u6d41\u7a0b\u8282\u70b9\u5904\u7406\u7f16\u53f7[{}],\u8bf7\u68c0\u67e5\u6d41\u7a0b\u6a21\u677f\u6ce8\u518c\u5668", (Object)code);
            return;
        }
        if (!(processNode instanceof UserTaskProcessNode)) {
            return;
        }
        ProcessTemplateNodeUserTaskVo processTemplateNodeUserTaskVo = this.processTemplateNodeUserTaskService.findByNodeId(processTemplateNodeVo.getId());
        boolean nullSkip = processTemplateNodeUserTaskVo.getNullSkip();
        boolean sponsorRepeatSkip = processTemplateNodeUserTaskVo.getSponsorRepeatSkip();
        ProcessInstanceEntity processInstanceEntity = this.processInstanceService.findByProcessInstanceId(task.getProcessInstanceId());
        if (processInstanceEntity != null) {
            this.syncProcessInfoToClient(task, processInstanceEntity.getProcessNo(), processInstanceEntity.getApplicationName(), processTemplateNodeUserTaskVo.getCanEdit());
        }
        Collection<String> assigneeCodes = null;
        boolean signOptional = processTemplateNodeUserTaskVo.getSignOptional();
        ProcessInstanceDto processInstanceDto = (ProcessInstanceDto)this.taskService.getVariable(task.getId(), ProcessConstant.PROCESS_INSTANCE_PARAM_CODE, ProcessInstanceDto.class);
        if (signOptional) {
            Map taskAssigneesMap;
            Set mapEntry;
            Collection userDtos;
            if (processInstanceDto != null && !CollectionUtils.isEmpty((Map)processInstanceDto.getTaskAssignees()) && !CollectionUtils.isEmpty((Collection)(userDtos = (Collection)(mapEntry = (taskAssigneesMap = processInstanceDto.getTaskAssignees()).entrySet()).stream().filter(item -> ((String)item.getKey()).equals(task.getTaskDefinitionKey())).map(Map.Entry::getValue).findFirst().orElse(null)))) {
                Set<String> oldAssigneeCodes = userDtos.stream().filter(item -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)item.getUserName())).map(ProcessUserDto::getUserName).collect(Collectors.toSet());
                assigneeCodes = this.buildDelegateUserNames(processInstanceEntity, oldAssigneeCodes, task, processTemplateNodeVo.getTemplateId());
            }
        } else {
            Collection<String> assigneesByTaskNodeIdAndTaskId = this.processTaskService.findAssigneesByTaskNodeIdAndTaskId(processTemplateNodeVo.getId(), taskId, task.getProcessInstanceId(), task.getTaskDefinitionKey(), null);
            assigneeCodes = this.buildDelegateUserNames(processInstanceEntity, assigneesByTaskNodeIdAndTaskId, task, processTemplateNodeVo.getTemplateId());
        }
        if (!CollectionUtils.isEmpty(assigneeCodes)) {
            ArrayList<String> cAssigness = new ArrayList<String>();
            if (ProcessConstant.PROCESS_SIGN_TYPE_MULTI.equals(processTemplateNodeUserTaskVo.getSignType())) {
                List<String> oldAssignees = this.taskMultiCacheVoService.get(task.getProcessInstanceId() + ":" + task.getTaskDefinitionKey());
                if (!CollectionUtils.isEmpty(oldAssignees)) {
                    List newAssigneeCodes = assigneeCodes.stream().filter(s -> !oldAssignees.contains(s)).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(newAssigneeCodes)) {
                        this.taskService.addCandidateUser(taskId, (String)newAssigneeCodes.get(0));
                        cAssigness.add((String)newAssigneeCodes.get(0));
                    }
                    cAssigness.addAll(oldAssignees);
                    this.taskMultiCacheVoService.set(task.getProcessInstanceId() + ":" + task.getTaskDefinitionKey(), cAssigness);
                } else {
                    String next = (String)assigneeCodes.stream().iterator().next();
                    this.taskService.addCandidateUser(taskId, next);
                    this.taskMultiCacheVoService.set(task.getProcessInstanceId() + ":" + task.getTaskDefinitionKey(), Collections.singletonList(next));
                }
            } else {
                assigneeCodes.forEach(item -> this.taskService.addCandidateUser(taskId, item));
            }
        } else {
            if (nullSkip) {
                log.debug("\u4efb\u52a1\u8282\u70b9[{}], id[{}],\u5ba1\u6279\u4eba\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u8be5\u8282\u70b9", (Object)task.getName(), (Object)task.getTaskDefinitionKey());
                this.taskService.addComment(task.getId(), task.getProcessInstanceId(), String.format("\u4efb\u52a1\u8282\u70b9[%s], \u5ba1\u6279\u4eba\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u8be5\u8282\u70b9", task.getName()));
                this.skipTask(task);
                return;
            }
            if (!processInstanceDto.isProcessValidate()) {
                log.debug("\u4efb\u52a1\u8282\u70b9[{}], id[{}],\u5ba1\u6279\u4eba\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u7ee7\u7eed\u8fdb\u884c\uff0c\u8bf7\u68c0\u67e5\uff01", (Object)processTemplateNodeVo.getName(), (Object)task.getTaskDefinitionKey());
                throw new IllegalArgumentException(String.format("\u4efb\u52a1\u8282\u70b9[%s], id[%s]\u5ba1\u6279\u4eba\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u7ee7\u7eed\u8fdb\u884c\uff0c\u8bf7\u68c0\u67e5\uff01", task.getName(), task.getTaskDefinitionKey()));
            }
        }
        if (!CollectionUtils.isEmpty(assigneeCodes) || StringUtils.hasText((String)task.getAssignee())) {
            ProcessInstance processInstance;
            String sponsor;
            userCodes = Sets.newHashSet();
            userCodes.addAll(assigneeCodes);
            userCodes.add(task.getAssignee());
            if (sponsorRepeatSkip && userCodes.contains(sponsor = (processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceTenantId(TenantUtils.getTenantCode()).processInstanceId(task.getProcessInstanceId()).singleResult()).getStartUserId()) && StringUtils.hasText((String)sponsor)) {
                this.taskService.addComment(task.getId(), task.getProcessInstanceId(), String.format("\u5ba1\u6279\u4eba[%s]\u4e3a\u53d1\u8d77\u4eba,\u8df3\u8fc7\u8282\u70b9[%s]\u3002", sponsor, task.getName()));
                this.skipTask(task, sponsor);
                return;
            }
        }
        if (Boolean.TRUE.equals(processTemplateNodeUserTaskVo.getApproverRepeatSkip())) {
            userCodes = Sets.newHashSet();
            userCodes.addAll(assigneeCodes);
            userCodes.add(task.getAssignee());
            List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskTenantId(TenantUtils.getTenantCode())).processInstanceId(task.getProcessInstanceId())).list();
            HashSet approves = Sets.newHashSet();
            historicTaskInstances.forEach(item -> {
                if (!item.getTaskDefinitionKey().equals(task.getTaskDefinitionKey()) && StringUtils.hasText((String)item.getAssignee())) {
                    approves.add(item.getAssignee());
                }
            });
            userCodes = userCodes.stream().filter(StringUtils::hasText).collect(Collectors.toSet());
            Sets.SetView mixed = Sets.intersection((Set)userCodes, (Set)approves);
            if (!CollectionUtils.isEmpty((Collection)mixed)) {
                mixed.forEach(item -> {
                    this.taskService.addComment(task.getId(), task.getProcessInstanceId(), String.format("\u5ba1\u6279\u4eba[%s],\u91cd\u590d\u5ba1\u6279\u8be5\u8282\u70b9[%s],\u8df3\u8fc7\u8be5\u8282\u70b9\u3002", item, task.getName()));
                    this.skipTask(task, (String)item);
                });
            }
        }
    }

    private ProcessNode findCurrentProcessNode(String code) {
        if (CollectionUtils.isEmpty(this.processNodes)) {
            return null;
        }
        return this.processNodes.stream().filter(item -> item.getCode().equals(code)).findFirst().orElse(null);
    }

    public int getOrder() {
        return 1;
    }

    private void skipTask(Task task) {
        this.skipTask(task, null);
    }

    private void skipTask(Task task, String assignee) {
        log.debug("\u4efb\u52a1\u8282\u70b9{}, id{},\u8df3\u8fc7\u8be5\u8282\u70b9", (Object)task.getName(), (Object)task.getTaskDefinitionKey());
        try {
            this.taskService.setVariable(task.getId(), ProcessConstant.PROCESS_INSTANCE_OPERATE_CODE, (Object)ProcessStatusEnum.PASS.getDictCode());
            if (StringUtils.hasText((String)assignee)) {
                this.taskService.claim(task.getId(), assignee);
            }
            this.taskService.complete(task.getId());
        }
        catch (FlowableException e) {
            log.error("{}\u5ba1\u6279\u51fa\u73b0\u5f02\u5e38,{}", (Object)task.getName(), (Object)Throwables.getStackTraceAsString((Throwable)e));
            String message = e.getMessage();
            if (message.contains("Gateway_")) {
                int gateway_ = message.indexOf("Gateway_");
                String key = message.substring(gateway_, gateway_ + 15);
                List data = this.processTemplateNodeService.findByProcessDefinitionId(task.getProcessDefinitionId());
                Validate.notEmpty((Collection)data, (String)"\u5f53\u524d\u7f51\u5173\u8282\u70b9\u4e0d\u5b58\u5728", (Object[])new Object[0]);
                Optional<ProcessTemplateNodeVo> first = data.stream().filter(a -> key.equals(a.getProcessTaskId())).findFirst();
                if (first.isPresent()) {
                    Validate.isTrue((boolean)false, (String)(Optional.ofNullable(first.get().getProcessTaskName()).orElse(key) + "\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\uff01"), (Object[])new Object[0]);
                } else {
                    Validate.isTrue((boolean)false, (String)"\u5f53\u524d\u7f51\u5173\u8282\u70b9\u4e0d\u5b58\u5728", (Object[])new Object[0]);
                }
            } else {
                Validate.isTrue((boolean)false, (String)(task.getName() + "\u5ba1\u6279\u51fa\u73b0\u5f02\u5e38"), (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("{}\u5ba1\u6279\u51fa\u73b0\u5f02\u5e38,{}", (Object)task.getName(), (Object)Throwables.getStackTraceAsString((Throwable)e));
            Validate.isTrue((boolean)false, (String)(task.getName() + "\u5ba1\u6279\u51fa\u73b0\u5f02\u5e38"), (Object[])new Object[0]);
        }
        ProcessTaskLogDto processTaskLogDto = new ProcessTaskLogDto();
        processTaskLogDto.setProcessInstanceId(task.getProcessInstanceId());
        processTaskLogDto.setOperateType(ProcessOperateTypeEnum.SKIP.getDictCode());
        processTaskLogDto.setTenantCode(TenantUtils.getTenantCode());
        processTaskLogDto.setOperateRemark(ProcessOperateTypeEnum.SKIP.getValue());
        Date date = new Date();
        processTaskLogDto.setCreateTime(date);
        processTaskLogDto.setCreateAccount("\u8df3\u8fc7");
        processTaskLogDto.setCreateName("\u8df3\u8fc7");
        processTaskLogDto.setModifyAccount("\u8df3\u8fc7");
        processTaskLogDto.setModifyName("\u8df3\u8fc7");
        processTaskLogDto.setModifyTime(date);
        this.processTaskLogService.create(processTaskLogDto);
    }

    private void syncProcessInfoToClient(Task task, String processNo, String applicationName, Boolean canEdit) {
        ProcessStatusDto processStatusDto = new ProcessStatusDto();
        processStatusDto.setProcessNo(processNo);
        processStatusDto.setCanEdit(canEdit);
        processStatusDto.setTaskId(task.getTaskDefinitionId());
        processStatusDto.setTaskName(task.getName());
        processStatusDto.setApplicationName(applicationName);
        SerializableBiConsumer & Serializable sf = ProcessStatusListener::onProcessInfoChanged;
        this.nebulaNetEventClient.publish((NebulaEventDto)processStatusDto, ProcessStatusListener.class, (SerializableBiConsumer)sf);
    }

    private Collection<String> buildDelegateUserNames(ProcessInstanceEntity processInstanceEntity, Collection<String> userNames, Task task, String templateId) {
        ProcessDelegateCopyDto processDelegateCopyDto = new ProcessDelegateCopyDto();
        if (Objects.isNull((Object)processInstanceEntity)) {
            WorkflowUserIdentity loginDetails = (WorkflowUserIdentity)this.loginUserService.getAbstractLoginUser();
            processDelegateCopyDto.setCreateTime(new Date());
            processDelegateCopyDto.setCommitUserCode(loginDetails.getUserName());
            processDelegateCopyDto.setCommitUserName(loginDetails.getRealName());
        } else {
            processDelegateCopyDto.setCreateTime(processInstanceEntity.getCreateTime());
            processDelegateCopyDto.setCommitUserCode(processInstanceEntity.getCreateAccount());
            processDelegateCopyDto.setCommitUserName(processInstanceEntity.getCreateName());
        }
        processDelegateCopyDto.setUserNames(userNames);
        processDelegateCopyDto.setProcessTemplateId(templateId);
        processDelegateCopyDto.setProcessInstanceId(task.getProcessInstanceId());
        processDelegateCopyDto.setTaskId(task.getId());
        processDelegateCopyDto.setTaskName(task.getName());
        processDelegateCopyDto.setTaskDefinitionKey(task.getTaskDefinitionKey());
        processDelegateCopyDto.setSaveLog(true);
        ProcessInstanceDto processInstanceDto = (ProcessInstanceDto)this.taskService.getVariable(task.getId(), ProcessConstant.PROCESS_INSTANCE_PARAM_CODE, ProcessInstanceDto.class);
        processDelegateCopyDto.setBusinessFormNo(processInstanceDto.getBusinessFormNo());
        processDelegateCopyDto.setProcessTitle(processInstanceDto.getProcessTitle());
        Collection<String> delegateUserNames = this.processDelegateConfigService.getUserName(processDelegateCopyDto);
        return delegateUserNames;
    }
}

