/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.notifier;

import com.alibaba.fastjson.JSON;
import com.biz.crm.workflow.client.listener.ProcessInfoListener;
import com.biz.crm.workflow.local.service.ProcessInstanceCopyConfigService;
import com.biz.crm.workflow.local.service.ProcessInstanceFilesService;
import com.biz.crm.workflow.local.service.ProcessInstanceService;
import com.biz.crm.workflow.sdk.constant.ProcessConstant;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessInstanceCopyConfigDto;
import com.biz.crm.workflow.sdk.dto.ProcessInstanceDto;
import com.biz.crm.workflow.sdk.strategy.extensionfield.ProcessExtensionFieldStrategy;
import com.biz.crm.workflow.sdk.vo.ProcessInfoResponse;
import com.biz.crm.workflow.sdk.vo.ProcessInstanceVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProcessEventListener
implements ProcessInfoListener {
    private static final Logger log = LoggerFactory.getLogger(ProcessEventListener.class);
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private ProcessInstanceFilesService processInstanceFilesService;
    @Autowired
    private ProcessInstanceCopyConfigService processInstanceCopyConfigService;
    @Autowired
    private List<ProcessExtensionFieldStrategy> processExtensionFieldStrategies;

    public ProcessInfoResponse createProcess(ProcessBusinessDto processBusinessDto) {
        ProcessInstanceDto processInstanceDto = this.convertDto(processBusinessDto);
        ProcessInstanceVo processInstanceVo = this.processInstanceService.create(processInstanceDto);
        Validate.notNull((Object)processInstanceVo, (String)"\u6d41\u7a0b\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u56fe\u662f\u5426\u6b63\u6b63\u786e", (Object[])new Object[0]);
        ProcessInfoResponse processInfoResponse = ProcessInfoResponse.builder().processKey(processInstanceVo.getProcessKey()).processNo(processInstanceVo.getProcessNo()).businessNo(processInstanceVo.getBusinessFormNo()).build();
        return processInfoResponse;
    }

    @Transactional
    public ProcessInfoResponse startProcess(ProcessBusinessDto processBusinessDto) {
        ProcessInstanceDto processInstanceDto = this.convertDto(processBusinessDto);
        ProcessInstanceVo processInstanceVo = this.processInstanceService.startProcess(processInstanceDto);
        Validate.notNull((Object)processInstanceVo, (String)"\u6d41\u7a0b\u53d1\u8d77\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u53d1\u8d77\u53c2\u6570", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty((Map)processBusinessDto.getCopyConfigs())) {
            Map copyConfigsMap = processInstanceDto.getCopyConfigs();
            Set mapEntry = copyConfigsMap.entrySet();
            mapEntry.forEach(item -> {
                Collection processUserDtos = (Collection)item.getValue();
                if (!CollectionUtils.isEmpty((Collection)processUserDtos)) {
                    processUserDtos.forEach(processUserDto -> {
                        ProcessInstanceCopyConfigDto processInstanceCopyConfigDto = new ProcessInstanceCopyConfigDto();
                        processInstanceCopyConfigDto.setTenantCode(TenantUtils.getTenantCode());
                        processInstanceCopyConfigDto.setProcessInstanceId(processInstanceVo.getProcessInstanceId());
                        processInstanceCopyConfigDto.setProcessTaskId((String)item.getKey());
                        processInstanceCopyConfigDto.setUserCode(processUserDto.getUserCode());
                        processInstanceCopyConfigDto.setUserName(processUserDto.getUserName());
                        this.processInstanceCopyConfigService.create(processInstanceCopyConfigDto);
                    });
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)processBusinessDto.getFilesCodes())) {
            Collection processInstanceFilesDtos = processBusinessDto.getFilesCodes();
            processInstanceFilesDtos.forEach(item -> {
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setProcessInstanceId(processInstanceVo.getProcessInstanceId());
            });
            this.processInstanceFilesService.createBatch(processInstanceFilesDtos);
        }
        ProcessInfoResponse processInfoResponse = ProcessInfoResponse.builder().processKey(processInstanceVo.getProcessKey()).processNo(processInstanceVo.getProcessNo()).businessNo(processInstanceVo.getBusinessFormNo()).processStatus(processInstanceVo.getProcessStatus()).build();
        return processInfoResponse;
    }

    private ProcessInstanceDto convertDto(ProcessBusinessDto processBusinessDto) {
        ProcessInstanceDto processInstanceDto = new ProcessInstanceDto();
        processInstanceDto.setTenantCode(TenantUtils.getTenantCode());
        processInstanceDto.setBusinessFormNo(processBusinessDto.getBusinessNo());
        processInstanceDto.setFormData(processBusinessDto.getBusinessFormJson());
        processInstanceDto.setExtData(processBusinessDto.getExtData());
        processInstanceDto.setApplicationName(processBusinessDto.getApplicationName());
        processInstanceDto.setBusinessCode(processBusinessDto.getBusinessCode());
        processInstanceDto.setProcessTitle(processBusinessDto.getProcessTitle());
        processInstanceDto.setProcessKey(processBusinessDto.getProcessKey());
        processInstanceDto.setTenantCode(processBusinessDto.getTenantCode());
        processInstanceDto.setFilesCodes(processBusinessDto.getFilesCodes());
        processInstanceDto.setTaskAssignees(processBusinessDto.getTaskAssignees());
        processInstanceDto.setCopyConfigs(processBusinessDto.getCopyConfigs());
        processInstanceDto.setProcessNo(processBusinessDto.getProcessNo());
        processInstanceDto.setRemark(processBusinessDto.getRemark());
        return processInstanceDto;
    }

    private void validateExtensionField(ProcessBusinessDto processBusinessDto) {
        List<ProcessExtensionFieldStrategy> strategies;
        Validate.notNull((Object)processBusinessDto, (String)"\u6d41\u7a0b\u521b\u5efa\u65f6\uff0c\u53d1\u8d77\u53c2\u6570\u5fc5\u586b", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(this.processExtensionFieldStrategies) && !CollectionUtils.isEmpty(strategies = this.processExtensionFieldStrategies.stream().filter(processExtensionFieldStrategy -> processExtensionFieldStrategy.getFunctionCode().equals(processBusinessDto.getBusinessCode())).collect(Collectors.toList()))) {
            Validate.notNull((Object)processBusinessDto.getBusinessFormJson(), (String)"\u6d41\u7a0b\u53d1\u8d77\u65f6\uff0c\u6269\u5c55\u5b57\u6bb5\u7684\u4e1a\u52a1\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            HashMap params = Maps.newHashMap();
            params.put(ProcessConstant.PROCESS_INSTANCE_FORM_DATA_CODE, JSON.parseObject((String)processBusinessDto.getBusinessFormJson()));
            strategies.forEach(processExtensionFieldStrategy -> processExtensionFieldStrategy.onValidate(params));
        }
    }
}

