/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.workflow.local.entity.ProcessButtonGroup;
import com.biz.crm.workflow.local.mapper.ProcessButtonGroupMapper;
import com.biz.crm.workflow.sdk.dto.ProcessButtonGroupDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ProcessButtonGroupRepository
extends ServiceImpl<ProcessButtonGroupMapper, ProcessButtonGroup> {
    @Autowired
    private ProcessButtonGroupMapper bpmProcessButtonGroupMapper;

    public Page<ProcessButtonGroup> findByConditions(Pageable pageable, ProcessButtonGroupDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.bpmProcessButtonGroupMapper.findByConditions((Page<ProcessButtonGroup>)page, dto);
    }

    public List<ProcessButtonGroup> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public ProcessButtonGroup findByButtonGroupCode(String buttonGroupCode) {
        if (StringUtils.isEmpty((CharSequence)buttonGroupCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (ProcessButtonGroup)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessButtonGroup::getButtonGroupCode, (Object)buttonGroupCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).one());
    }

    public ProcessButtonGroup findByIdAndTenantCode(String id, String tenantCode) {
        return (ProcessButtonGroup)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public void removeByIdsAndTenantCode(Collection<String> ids, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).remove();
    }

    public void updateByIdAndTenantCode(ProcessButtonGroup newBpmProcessButtonGroup, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{newBpmProcessButtonGroup.getId()});
        ((ProcessButtonGroupMapper)this.baseMapper).update((Object)newBpmProcessButtonGroup, (Wrapper)lambdaUpdateWrapper);
    }
}

