/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.workflow.local.entity.ProcessTaskCopyConfigEntity;
import com.biz.crm.workflow.local.mapper.ProcessCopyConfigMapper;
import com.biz.crm.workflow.sdk.dto.ProcessTaskCopyConfigDto;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCopyConfigVo;
import com.bizunited.nebula.common.entity.TenantOpEntity;
import com.bizunited.nebula.common.entity.UuidEntity;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProcessCopyConfigRepository
extends ServiceImpl<ProcessCopyConfigMapper, ProcessTaskCopyConfigEntity> {
    @Autowired
    private ProcessCopyConfigMapper processCopyConfigMapper;

    public Page<ProcessTaskCopyConfigVo> findByConditions(Pageable pageable, ProcessTaskCopyConfigDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.processCopyConfigMapper.findByConditions((Page<ProcessTaskCopyConfigVo>)page, dto);
    }

    public List<ProcessTaskCopyConfigEntity> findByNodeIds(Collection<String> nodeIds) {
        if (CollectionUtils.isEmpty(nodeIds)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProcessTaskCopyConfigEntity::getTaskNodeId, nodeIds)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ProcessTaskCopyConfigEntity> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public void removeByIdsAndTenantCode(Collection<String> ids, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).remove();
    }
}

