/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.workflow.local.entity.ProcessInstanceAssignee;
import com.biz.crm.workflow.local.mapper.ProcessInstanceAssigneeMapper;
import com.biz.crm.workflow.sdk.dto.ProcessInstanceAssigneeDto;
import com.biz.crm.workflow.sdk.vo.ProcessInstanceAssigneeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProcessInstanceAssigneeRepository
extends ServiceImpl<ProcessInstanceAssigneeMapper, ProcessInstanceAssignee> {
    @Autowired
    private ProcessInstanceAssigneeMapper processInstanceAssigneeMapper;

    public Page<ProcessInstanceAssigneeVo> findByConditions(Pageable pageable, ProcessInstanceAssigneeDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.processInstanceAssigneeMapper.findByConditions((Page<ProcessInstanceAssigneeVo>)page, dto);
    }

    public List<ProcessInstanceAssignee> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ProcessInstanceAssignee> findByProcessInstanceIdAndTaskId(String processInstanceId, String taskId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{processInstanceId, taskId})) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessInstanceAssignee::getProcessInstanceId, (Object)processInstanceId)).eq(ProcessInstanceAssignee::getProcessTaskId, (Object)taskId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public ProcessInstanceAssignee findByIdAndTenantCode(String id, String tenantCode) {
        return (ProcessInstanceAssignee)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }
}

