/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.workflow.local.entity.ProcessInstanceCopyConfig;
import com.biz.crm.workflow.local.mapper.ProcessInstanceCopyConfigMapper;
import com.biz.crm.workflow.sdk.dto.ProcessInstanceCopyConfigDto;
import com.biz.crm.workflow.sdk.vo.ProcessInstanceCopyConfigVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ProcessInstanceCopyConfigRepository
extends ServiceImpl<ProcessInstanceCopyConfigMapper, ProcessInstanceCopyConfig> {
    @Autowired
    private ProcessInstanceCopyConfigMapper processInstanceCopyConfigMapper;

    public Page<ProcessInstanceCopyConfigVo> findByConditions(Pageable pageable, ProcessInstanceCopyConfigDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.processInstanceCopyConfigMapper.findByConditions((Page<ProcessInstanceCopyConfigVo>)page, dto);
    }

    public List<ProcessInstanceCopyConfig> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ProcessInstanceCopyConfig> findByProcessInstanceId(String processInstanceId) {
        if (!StringUtils.hasText((String)processInstanceId)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessInstanceCopyConfig::getProcessInstanceId, (Object)processInstanceId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public ProcessInstanceCopyConfig findByIdAndTenantCode(String id, String tenantCode) {
        return (ProcessInstanceCopyConfig)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }
}

