/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.workflow.local.entity.ProcessInstanceFiles;
import com.biz.crm.workflow.local.mapper.ProcessInstanceFilesMapper;
import com.biz.crm.workflow.sdk.dto.ProcessInstanceFilesDto;
import com.biz.crm.workflow.sdk.vo.ProcessInstanceFilesVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ProcessInstanceFilesRepository
extends ServiceImpl<ProcessInstanceFilesMapper, ProcessInstanceFiles> {
    @Autowired
    private ProcessInstanceFilesMapper processInstanceFilesMapper;

    public Page<ProcessInstanceFilesVo> findByConditions(Pageable pageable, ProcessInstanceFilesDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.processInstanceFilesMapper.findByConditions((Page<ProcessInstanceFilesVo>)page, dto);
    }

    public List<ProcessInstanceFiles> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ProcessInstanceFiles> findByProcessInstanceId(String processInstanceId) {
        if (!StringUtils.hasText((String)processInstanceId)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProcessInstanceFiles::getProcessInstanceId, new Object[]{processInstanceId})).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public ProcessInstanceFiles findByIdAndTenantCode(String id, String tenantCode) {
        return (ProcessInstanceFiles)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public void removeByIdsAndTenantCode(Collection<String> ids, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).remove();
    }
}

