/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.workflow.local.entity.ProcessInstanceEntity;
import com.biz.crm.workflow.local.mapper.ProcessInstanceMapper;
import com.biz.crm.workflow.sdk.dto.ProcessInstanceDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.vo.ProcessInstanceVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProcessInstanceRepository
extends ServiceImpl<ProcessInstanceMapper, ProcessInstanceEntity> {
    @Autowired
    private ProcessInstanceMapper processInstanceMapper;

    public Page<ProcessInstanceVo> findByConditions(Pageable pageable, ProcessInstanceDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.processInstanceMapper.findByConditions((Page<ProcessInstanceVo>)page, dto);
    }

    public List<ProcessInstanceEntity> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public ProcessInstanceEntity findByInstanceId(String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            return null;
        }
        return (ProcessInstanceEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessInstanceEntity::getProcessInstanceId, (Object)processInstanceId)).eq(TenantOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public ProcessInstanceEntity findByBusinessNo(String businessNo) {
        if (StringUtils.isBlank((CharSequence)businessNo)) {
            return null;
        }
        return (ProcessInstanceEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessInstanceEntity::getBusinessFormNo, (Object)businessNo)).eq(ProcessInstanceEntity::getProcessStatus, (Object)ProcessStatusEnum.START.getKey())).one());
    }

    public ProcessInstanceEntity findByBusinessNoAndIncludeStatus(String businessNo, Collection<String> processStatus) {
        if (StringUtils.isBlank((CharSequence)businessNo)) {
            return null;
        }
        return (ProcessInstanceEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProcessInstanceEntity::getProcessStatus, processStatus)).eq(ProcessInstanceEntity::getBusinessFormNo, (Object)businessNo)).one());
    }

    public List<ProcessInstanceEntity> findByFormNo(String formNo) {
        if (StringUtils.isBlank((CharSequence)formNo)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessInstanceEntity::getBusinessFormNo, (Object)formNo)).list();
    }

    public ProcessInstanceEntity findByProcessNo(String processNo) {
        if (StringUtils.isBlank((CharSequence)processNo)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (ProcessInstanceEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(ProcessInstanceEntity::getProcessNo, (Object)processNo)).one());
    }

    public void updateInstanceStatusByIds(List<String> ids, String status) {
        if (CollectionUtils.isEmpty(ids) || StringUtils.isBlank((CharSequence)status)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(ProcessInstanceEntity::getProcessInstanceStatus, (Object)status)).update();
    }

    public Integer countByAccount(String account) {
        String processInstanceStatus = "enable";
        String processStatus = "4";
        String tenantCode = TenantUtils.getTenantCode();
        return ((ProcessInstanceMapper)this.baseMapper).countByAccount(account, "enable", "4", tenantCode);
    }
}

