/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.workflow.local.entity.ProcessPreExecutionLogEntity;
import com.biz.crm.workflow.local.mapper.ProcessPreExecutionMapper;
import com.biz.crm.workflow.sdk.enums.PreExecutionStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ProcessPreExecutionRepository
extends ServiceImpl<ProcessPreExecutionMapper, ProcessPreExecutionLogEntity> {
    public List<ProcessPreExecutionLogEntity> findPreExecutionLogByProcessInstanceIdAndTemplateId(String processInstanceId, String processTemplateId) {
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessPreExecutionLogEntity::getProcessInstanceId, (Object)processInstanceId)).eq(ProcessPreExecutionLogEntity::getProcessTemplateId, (Object)processTemplateId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).orderByDesc(ProcessPreExecutionLogEntity::getSort)).list();
    }

    public void updatePreLogAllByProcessInstanceIdAndTaskDefinitionKey(String processInstanceId, String taskNodeKey, String tracingResult) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ProcessPreExecutionLogEntity::getProcessInstanceId, (Object)processInstanceId)).eq(ProcessPreExecutionLogEntity::getTaskDefinitionKey, (Object)taskNodeKey)).eq(TenantOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(ProcessPreExecutionLogEntity::getTracingResult, (Object)tracingResult)).set(ProcessPreExecutionLogEntity::getProcessStatus, (Object)PreExecutionStatusEnum.EXECUTION_STATUS.getDictCode())).update();
    }

    public void updatePreLogByProcessInstanceIdAndTaskDefinitionKey(String processInstanceId, String taskNodeKey, String tracingResult) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ProcessPreExecutionLogEntity::getProcessInstanceId, (Object)processInstanceId)).eq(ProcessPreExecutionLogEntity::getTaskDefinitionKey, (Object)taskNodeKey)).eq(TenantOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(ProcessPreExecutionLogEntity::getTracingResult, (Object)tracingResult)).update();
    }
}

