/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.workflow.local.entity.ProcessTaskCommunicateEntity;
import com.biz.crm.workflow.local.mapper.ProcessTaskCommunicateMapper;
import com.biz.crm.workflow.sdk.dto.ProcessTaskCommunicateDto;
import com.biz.crm.workflow.sdk.vo.ProcessTaskCommunicateVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProcessTaskCommunicateRepository
extends ServiceImpl<ProcessTaskCommunicateMapper, ProcessTaskCommunicateEntity> {
    @Autowired
    private ProcessTaskCommunicateMapper processTaskCommunicateMapper;

    public Page<ProcessTaskCommunicateVo> findByConditions(Pageable pageable, ProcessTaskCommunicateDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.processTaskCommunicateMapper.findByConditions((Page<ProcessTaskCommunicateVo>)page, dto);
    }

    public List<ProcessTaskCommunicateEntity> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ProcessTaskCommunicateEntity> findByTaskIdAndStatus(String taskId, String communicateStatus) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{taskId, communicateStatus})) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProcessTaskCommunicateEntity::getTaskId, new Object[]{taskId})).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(ProcessTaskCommunicateEntity::getStatus, (Object)communicateStatus)).list();
    }

    public List<ProcessTaskCommunicateEntity> findByProcessInstanceIdAndStatus(String processInstanceId, String communicateStatus) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{processInstanceId, communicateStatus})) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProcessTaskCommunicateEntity::getProcessInstanceId, new Object[]{processInstanceId})).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(ProcessTaskCommunicateEntity::getStatus, (Object)communicateStatus)).list();
    }

    public ProcessTaskCommunicateEntity findByIdAndTenantCode(String id, String tenantCode) {
        return (ProcessTaskCommunicateEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public void removeByIdsAndTenantCode(Collection<String> ids, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).remove();
    }

    public void updateByIdAndTenantCode(ProcessTaskCommunicateEntity communicateEntity, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantOpEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{communicateEntity.getId()});
        ((ProcessTaskCommunicateMapper)this.baseMapper).update((Object)communicateEntity, (Wrapper)lambdaUpdateWrapper);
    }
}

