/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.workflow.local.entity.ProcessTaskIndicatorsEntity;
import com.biz.crm.workflow.local.mapper.ProcessTaskIndicatorsMapper;
import com.biz.crm.workflow.sdk.dto.ProcessTaskIndicatorsDto;
import com.biz.crm.workflow.sdk.vo.ProcessTaskIndicatorsVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProcessTaskIndicatorsRepository
extends ServiceImpl<ProcessTaskIndicatorsMapper, ProcessTaskIndicatorsEntity> {
    @Autowired
    private ProcessTaskIndicatorsMapper processTaskIndicatorsMapper;

    public Page<ProcessTaskIndicatorsVo> findByConditions(Pageable pageable, ProcessTaskIndicatorsDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.processTaskIndicatorsMapper.findByConditions((Page<ProcessTaskIndicatorsVo>)page, dto);
    }

    public List<ProcessTaskIndicatorsEntity> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ProcessTaskIndicatorsEntity> findByTaskNodeIds(List<String> taskNodeIds) {
        if (CollectionUtils.isEmpty(taskNodeIds)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProcessTaskIndicatorsEntity::getTaskNodeId, taskNodeIds)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public boolean deleteByTaskNodeIds(List<String> taskNodeIds) {
        if (CollectionUtils.isEmpty(taskNodeIds)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(ProcessTaskIndicatorsEntity::getTaskNodeId, taskNodeIds)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public void removeByIdsAndTenantCode(Collection<String> ids, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).remove();
    }
}

