/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.workflow.local.dto.ProcessTaskLogDto;
import com.biz.crm.workflow.local.entity.ProcessTaskLogEntity;
import com.biz.crm.workflow.local.mapper.ProcessTaskLogMapper;
import com.biz.crm.workflow.local.vo.ProcessTaskLogVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProcessTaskLogRepository
extends ServiceImpl<ProcessTaskLogMapper, ProcessTaskLogEntity> {
    @Autowired
    private ProcessTaskLogMapper processTaskLogMapper;

    public Page<ProcessTaskLogVo> findByConditions(Pageable pageable, ProcessTaskLogDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.processTaskLogMapper.findByConditions((Page<ProcessTaskLogVo>)page, dto);
    }

    public List<ProcessTaskLogEntity> findByProcessInstanceIds(List<String> processInstanceIds) {
        if (CollectionUtils.isEmpty(processInstanceIds)) {
            return Lists.newArrayList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProcessTaskLogEntity::getProcessInstanceId, processInstanceIds)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).orderByDesc(UuidOpEntity::getCreateTime)).list();
    }

    public List<ProcessTaskLogEntity> findByBusinessFormId(String businessFormId) {
        if (StringUtils.isBlank((CharSequence)businessFormId)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessTaskLogEntity::getBusinessFormId, (Object)businessFormId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public boolean deleteByProcessInstanceId(String processInstanceId) {
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ProcessTaskLogEntity::getProcessInstanceId, (Object)processInstanceId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public List<ProcessTaskLogEntity> findByProcessInstanceIdAndOperateType(String processInstanceId, String operateType) {
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessTaskLogEntity::getProcessInstanceId, (Object)processInstanceId)).eq(ProcessTaskLogEntity::getOperateType, (Object)operateType)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }
}

