/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.workflow.local.entity.ProcessTemplateNodeAssignee;
import com.biz.crm.workflow.local.mapper.ProcessTemplateNodeAssigneeMapper;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeAssigneeDto;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeAssigneeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProcessTemplateNodeAssigneeRepository
extends ServiceImpl<ProcessTemplateNodeAssigneeMapper, ProcessTemplateNodeAssignee> {
    @Autowired
    private ProcessTemplateNodeAssigneeMapper processTemplateNodeAssigneeMapper;

    public Page<ProcessTemplateNodeAssigneeVo> findByConditions(Pageable pageable, ProcessTemplateNodeAssigneeDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.processTemplateNodeAssigneeMapper.findByConditions((Page<ProcessTemplateNodeAssigneeVo>)page, dto);
    }

    public List<ProcessTemplateNodeAssignee> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ProcessTemplateNodeAssignee> findByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessTemplateNodeAssignee::getTemplateId, (Object)templateId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ProcessTemplateNodeAssignee> findByTemplateIds(Collection<String> templateIds) {
        if (CollectionUtils.isEmpty(templateIds)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProcessTemplateNodeAssignee::getTemplateId, templateIds)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public boolean deleteByTemplateCode(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ProcessTemplateNodeAssignee::getTemplateId, (Object)templateId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public List<ProcessTemplateNodeAssignee> findByNodeId(String nodeId) {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessTemplateNodeAssignee::getNodeId, (Object)nodeId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ProcessTemplateNodeAssignee> findByNodeIds(Collection<String> nodeIds) {
        if (CollectionUtils.isEmpty(nodeIds)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProcessTemplateNodeAssignee::getNodeId, nodeIds)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public boolean deleteByNodeId(String nodeId) {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ProcessTemplateNodeAssignee::getNodeId, (Object)nodeId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public ProcessTemplateNodeAssignee findByIdAndTenantCode(String id, String tenantCode) {
        return (ProcessTemplateNodeAssignee)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public void removeByIdsAndTenantCode(Set<String> collect, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, collect)).remove();
    }
}

