/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.workflow.local.entity.ProcessTemplateNodeAssigneeVar;
import com.biz.crm.workflow.local.mapper.ProcessTemplateNodeAssigneeVarMapper;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeAssigneeVarDto;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeAssigneeVarVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProcessTemplateNodeAssigneeVarRepository
extends ServiceImpl<ProcessTemplateNodeAssigneeVarMapper, ProcessTemplateNodeAssigneeVar> {
    @Autowired
    private ProcessTemplateNodeAssigneeVarMapper processTemplateNodeAssigneeVarMapper;

    public Page<ProcessTemplateNodeAssigneeVarVo> findByConditions(Pageable pageable, ProcessTemplateNodeAssigneeVarDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.processTemplateNodeAssigneeVarMapper.findByConditions((Page<ProcessTemplateNodeAssigneeVarVo>)page, dto);
    }

    public List<ProcessTemplateNodeAssigneeVar> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ProcessTemplateNodeAssigneeVar> findByNodeAssigneeId(String nodeAssigneeId) {
        if (StringUtils.isBlank((CharSequence)nodeAssigneeId)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessTemplateNodeAssigneeVar::getNodeAssigneeId, (Object)nodeAssigneeId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public ProcessTemplateNodeAssigneeVar findByIdAndTenantCode(String id, String tenantCode) {
        return (ProcessTemplateNodeAssigneeVar)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public void removeByIdsAndTenantCode(Collection<String> ids, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).remove();
    }
}

