/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.workflow.local.entity.ProcessTemplateNodeEmailFiles;
import com.biz.crm.workflow.local.mapper.ProcessTemplateNodeEmailFilesMapper;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeEmailFilesDto;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeEmailFilesVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProcessTemplateNodeEmailFilesRepository
extends ServiceImpl<ProcessTemplateNodeEmailFilesMapper, ProcessTemplateNodeEmailFiles> {
    @Autowired
    private ProcessTemplateNodeEmailFilesMapper processTemplateNodeEmailFilesMapper;

    public Page<ProcessTemplateNodeEmailFilesVo> findByConditions(Pageable pageable, ProcessTemplateNodeEmailFilesDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.processTemplateNodeEmailFilesMapper.findByConditions((Page<ProcessTemplateNodeEmailFilesVo>)page, dto);
    }

    public List<ProcessTemplateNodeEmailFiles> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ProcessTemplateNodeEmailFiles> findByNodeEmailId(String nodeEmailId) {
        if (StringUtils.isBlank((CharSequence)nodeEmailId)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessTemplateNodeEmailFiles::getNodeEmailId, (Object)nodeEmailId)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public boolean deleteByNodeEmailId(String nodeEmailId) {
        if (StringUtils.isBlank((CharSequence)nodeEmailId)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ProcessTemplateNodeEmailFiles::getNodeEmailId, (Object)nodeEmailId)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public ProcessTemplateNodeEmailFiles findByIdAndTenantCode(String id, String tenantCode) {
        return (ProcessTemplateNodeEmailFiles)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public void removeByIdsAndTenantCode(Collection<String> ids, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).remove();
    }
}

