/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.workflow.local.entity.ProcessTemplateNodeEndTask;
import com.biz.crm.workflow.local.mapper.ProcessTemplateNodeEndTaskMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProcessTemplateNodeEndTaskRepository
extends ServiceImpl<ProcessTemplateNodeEndTaskMapper, ProcessTemplateNodeEndTask> {
    public List<ProcessTemplateNodeEndTask> findByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessTemplateNodeEndTask::getTemplateId, (Object)templateId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ProcessTemplateNodeEndTask> findByTemplateIds(Collection<String> templateIds) {
        if (CollectionUtils.isEmpty(templateIds)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProcessTemplateNodeEndTask::getTemplateId, templateIds)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public boolean deleteByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ProcessTemplateNodeEndTask::getTemplateId, (Object)templateId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public void deleteByIds(Collection<String> ids, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).remove();
    }

    public void deleteByNodeIds(List<String> nodeIds) {
        String tenantCode = TenantUtils.getTenantCode();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(ProcessTemplateNodeEndTask::getNodeId, nodeIds)).remove();
    }

    public List<ProcessTemplateNodeEndTask> findByIds(Collection<String> ids) {
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).list();
    }

    public ProcessTemplateNodeEndTask findByNodeId(String nodeId) {
        String tenantCode = TenantUtils.getTenantCode();
        return (ProcessTemplateNodeEndTask)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(ProcessTemplateNodeEndTask::getNodeId, (Object)nodeId)).one());
    }
}

