/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.workflow.local.entity.ProcessTemplateNodeExtensionField;
import com.biz.crm.workflow.local.mapper.ProcessTemplateNodeExtensionFieldMapper;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeExtensionFieldDto;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeExtensionFieldVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProcessTemplateNodeExtensionFieldRepository
extends ServiceImpl<ProcessTemplateNodeExtensionFieldMapper, ProcessTemplateNodeExtensionField> {
    @Autowired
    private ProcessTemplateNodeExtensionFieldMapper processTemplateNodeExtensionFieldMapper;

    public Page<ProcessTemplateNodeExtensionFieldVo> findByConditions(Pageable pageable, ProcessTemplateNodeExtensionFieldDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.processTemplateNodeExtensionFieldMapper.findByConditions((Page<ProcessTemplateNodeExtensionFieldVo>)page, dto);
    }

    public List<ProcessTemplateNodeExtensionField> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ProcessTemplateNodeExtensionField> findByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessTemplateNodeExtensionField::getTemplateId, (Object)templateId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ProcessTemplateNodeExtensionField> findByTemplateIds(Collection<String> templateIds) {
        if (CollectionUtils.isEmpty(templateIds)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProcessTemplateNodeExtensionField::getTemplateId, templateIds)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public boolean deleteByTemplateCode(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ProcessTemplateNodeExtensionField::getTemplateId, (Object)templateId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public ProcessTemplateNodeExtensionField findByNodeId(String nodeId) {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (ProcessTemplateNodeExtensionField)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessTemplateNodeExtensionField::getNodeId, (Object)nodeId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).one());
    }

    public List<ProcessTemplateNodeExtensionField> findByNodeIds(Collection<String> nodeIds) {
        if (CollectionUtils.isEmpty(nodeIds)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProcessTemplateNodeExtensionField::getNodeId, nodeIds)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public boolean deleteByNodeId(String nodeId) {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ProcessTemplateNodeExtensionField::getNodeId, (Object)nodeId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public boolean deleteByNodeIds(Collection<String> nodeIds) {
        if (CollectionUtils.isEmpty(nodeIds)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(ProcessTemplateNodeExtensionField::getNodeId, nodeIds)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public ProcessTemplateNodeExtensionField findByIdAndTenantCode(String id, String tenantCode) {
        return (ProcessTemplateNodeExtensionField)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }
}

