/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.workflow.local.entity.ProcessTemplateNode;
import com.biz.crm.workflow.local.mapper.ProcessTemplateNodeMapper;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeDto;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProcessTemplateNodeRepository
extends ServiceImpl<ProcessTemplateNodeMapper, ProcessTemplateNode> {
    @Autowired
    private ProcessTemplateNodeMapper processTemplateNodeMapper;

    public Page<ProcessTemplateNodeVo> findByConditions(Pageable pageable, ProcessTemplateNodeDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.processTemplateNodeMapper.findByConditions((Page<ProcessTemplateNodeVo>)page, dto);
    }

    public List<ProcessTemplateNode> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public ProcessTemplateNode findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (ProcessTemplateNode)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).one());
    }

    public List<ProcessTemplateNode> findByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessTemplateNode::getTemplateId, (Object)templateId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).orderByDesc(UuidOpEntity::getCreateTime)).list();
    }

    public ProcessTemplateNode findByTemplateIdAndTaskId(String templateId, String taskId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (ProcessTemplateNode)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessTemplateNode::getTemplateId, (Object)templateId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).eq(ProcessTemplateNode::getProcessTaskId, (Object)taskId)).one());
    }

    public List<ProcessTemplateNode> findByProcessDefinitionId(String processDefinitionId) {
        if (StringUtils.isBlank((CharSequence)processDefinitionId)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((ProcessTemplateNodeMapper)this.baseMapper).findByProcessDefinitionId(processDefinitionId, tenantCode);
    }

    public List<ProcessTemplateNode> findByTemplateIds(Collection<String> templateIds) {
        if (CollectionUtils.isEmpty(templateIds)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProcessTemplateNode::getTemplateId, templateIds)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public ProcessTemplateNode findByProcessDefinitionIdAndTaskId(String processDefinitionId, String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((ProcessTemplateNodeMapper)this.baseMapper).findByProcessDefinitionIdAndTaskId(processDefinitionId, taskId, tenantCode);
    }

    public ProcessTemplateNode findByProcessProcessInstanceIdAndTaskId(String processInstanceId, String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((ProcessTemplateNodeMapper)this.baseMapper).findByProcessProcessInstanceIdAndTaskId(processInstanceId, taskId, tenantCode);
    }

    public void deleteByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ProcessTemplateNode::getTemplateId, (Object)templateId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public ProcessTemplateNode findByIdAndTenantCode(String id, String tenantCode) {
        return (ProcessTemplateNode)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public void removeByIdsAndTenantCode(Collection<String> ids, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).remove();
    }
}

