/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.workflow.local.entity.ProcessTemplateNodeSms;
import com.biz.crm.workflow.local.mapper.ProcessTemplateNodeSmsMapper;
import com.biz.crm.workflow.sdk.dto.ProcessTemplateNodeSmsDto;
import com.biz.crm.workflow.sdk.vo.ProcessTemplateNodeSmsVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProcessTemplateNodeSmsRepository
extends ServiceImpl<ProcessTemplateNodeSmsMapper, ProcessTemplateNodeSms> {
    @Autowired
    private ProcessTemplateNodeSmsMapper processTemplateNodeSmsMapper;

    public Page<ProcessTemplateNodeSmsVo> findByConditions(Pageable pageable, ProcessTemplateNodeSmsDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.processTemplateNodeSmsMapper.findByConditions((Page<ProcessTemplateNodeSmsVo>)page, dto);
    }

    public List<ProcessTemplateNodeSms> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public ProcessTemplateNodeSms findByNodeId(String nodeId) {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (ProcessTemplateNodeSms)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessTemplateNodeSms::getNodeId, (Object)nodeId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).one());
    }

    public void deleteByNodeId(String nodeId) {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ProcessTemplateNodeSms::getNodeId, (Object)nodeId)).eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public ProcessTemplateNodeSms findByIdAndTenantCode(String id, String tenantCode) {
        return (ProcessTemplateNodeSms)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public void removeByIdsAndTenantCode(Collection<String> ids, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).remove();
    }
}

