/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.workflow.local.entity.ProcessTemplate;
import com.biz.crm.workflow.local.mapper.ProcessTemplateMapper;
import com.biz.crm.workflow.sdk.dto.ProcessTemplatePageDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ProcessTemplateRepository
extends ServiceImpl<ProcessTemplateMapper, ProcessTemplate> {
    public Page<ProcessTemplate> findByConditions(Pageable pageable, ProcessTemplatePageDto processTemplatePageDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        processTemplatePageDto.setTenantCode(TenantUtils.getTenantCode());
        Page<ProcessTemplate> pageList = ((ProcessTemplateMapper)this.baseMapper).findByConditions((Page<ProcessTemplate>)page, processTemplatePageDto);
        return pageList;
    }

    public List<ProcessTemplate> findByConditions(ProcessTemplatePageDto processTemplatePageDto) {
        processTemplatePageDto.setTenantCode(TenantUtils.getTenantCode());
        return ((ProcessTemplateMapper)this.baseMapper).findByConditions(processTemplatePageDto);
    }

    public Page<ProcessTemplate> findUseProcessByConditions(Pageable pageable, ProcessTemplatePageDto processTemplatePageDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        processTemplatePageDto.setTenantCode(TenantUtils.getTenantCode());
        Page<ProcessTemplate> pageList = ((ProcessTemplateMapper)this.baseMapper).findUseProcessByConditions((Page<ProcessTemplate>)page, processTemplatePageDto);
        return pageList;
    }

    public List<ProcessTemplate> findUseProcessByConditions(ProcessTemplatePageDto processTemplatePageDto) {
        processTemplatePageDto.setTenantCode(TenantUtils.getTenantCode());
        return ((ProcessTemplateMapper)this.baseMapper).findUseProcessByConditions(processTemplatePageDto);
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public List<ProcessTemplate> findByProcessKey(String tenantCode, String processKey) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessTemplate::getProcessKey, (Object)processKey)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public ProcessTemplate findLastVersionByProcessKey(String tenantCode, String processKey) {
        return (ProcessTemplate)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessTemplate::getProcessKey, (Object)processKey)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(ProcessTemplate::getNewest, (Object)1)).one());
    }

    public ProcessTemplate findByProcessDefinitionId(String processDefinitionId) {
        String tenantCode = TenantUtils.getTenantCode();
        return (ProcessTemplate)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProcessTemplate::getProcessDefinitionId, (Object)processDefinitionId)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<ProcessTemplate> findByProcessKeyAndReleaseStatus(String processKey, String releaseStatus, String businessCode) {
        String tenantCode = TenantUtils.getTenantCode();
        return ((ProcessTemplateMapper)this.baseMapper).findByProcessKeyAndReleaseStatus(processKey, releaseStatus, tenantCode, businessCode);
    }

    public ProcessTemplate findByIdAndTenantCode(String id, String tenantCode) {
        return (ProcessTemplate)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public List<ProcessTemplate> listByIdsAndTenantCode(List<String> ids, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).list();
    }

    public void updateNewestByIdAndTenantCode(List<String> ids, String tenantCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).set(ProcessTemplate::getNewest, (Object)false)).update();
    }
}

