/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.workflow.local.entity.ProcessTodoDelegateEntity;
import com.biz.crm.workflow.local.mapper.ProcessTodoDelegateMapper;
import com.biz.crm.workflow.sdk.dto.ProcessTodoDelegateDto;
import com.biz.crm.workflow.sdk.vo.ProcessTodoDelegateVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ProcessTodoDelegateRepository
extends ServiceImpl<ProcessTodoDelegateMapper, ProcessTodoDelegateEntity> {
    @Autowired
    private ProcessTodoDelegateMapper processTodoDelegateMapper;

    public Page<ProcessTodoDelegateVo> findByConditions(Pageable pageable, ProcessTodoDelegateDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.processTodoDelegateMapper.findByConditions((Page<ProcessTodoDelegateVo>)page, dto);
    }

    public List<ProcessTodoDelegateEntity> findByUserCodeAndTime(ProcessTodoDelegateDto dto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().le(ProcessTodoDelegateEntity::getStartTime, (Object)dto.getEndTime())).ge(ProcessTodoDelegateEntity::getEndTime, (Object)dto.getStartTime())).eq(ProcessTodoDelegateEntity::getUserName, (Object)dto.getUserName())).eq(TenantOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void cancelDelegate(String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(UuidEntity::getId, (Object)id)).eq(TenantOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).remove();
    }

    public ProcessTodoDelegateEntity findByIdAndTenantCode(String id, String tenantCode) {
        return (ProcessTodoDelegateEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public Integer countByAccount(String account) {
        String tenantCode = TenantUtils.getTenantCode();
        String identityLinkType = "candidate";
        return ((ProcessTodoDelegateMapper)this.baseMapper).countByAccount(account, tenantCode, "candidate");
    }
}

