/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.workflow.local.service.cmd;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;
import org.flowable.bpmn.BpmnAutoLayout;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.Task;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.engine.impl.cmd.AbstractDynamicInjectionCmd;
import org.flowable.engine.impl.dynamic.BaseDynamicSubProcessInjectUtil;
import org.flowable.engine.impl.dynamic.DynamicUserTaskBuilder;
import org.flowable.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntityManager;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AfterSignUserTaskCmd
extends AbstractDynamicInjectionCmd
implements Command<Void> {
    private static final Logger log = LoggerFactory.getLogger(AfterSignUserTaskCmd.class);
    protected String processInstanceId;
    protected ProcessInstance processInstance;
    private DynamicUserTaskBuilder dynamicUserTaskBuilder;
    private FlowElement currentFlowElement;
    private FlowElement nextUserTask;
    private EndEvent endEvent;
    private String taskId;
    private static final String TASK_ID = "\u4efb\u52a1id:";
    private static final String NOT_FOUND = "\u672a\u627e\u5230";
    private static final String TYPE_ERROR = "\u7c7b\u522b\u9519\u8bef";

    public AfterSignUserTaskCmd(ProcessInstance processInstance, DynamicUserTaskBuilder signUserTaskBuilder, String taskId, FlowElement nextUserTask, EndEvent endEvent) {
        this.processInstance = processInstance;
        this.processInstanceId = processInstance.getProcessInstanceId();
        this.dynamicUserTaskBuilder = signUserTaskBuilder;
        this.taskId = taskId;
        this.nextUserTask = nextUserTask;
        this.endEvent = endEvent;
    }

    public Void execute(CommandContext commandContext) {
        TaskService taskService = CommandContextUtil.getTaskService((CommandContext)commandContext);
        TaskEntity taskEntity = taskService.getTask(this.taskId);
        if (taskEntity == null) {
            throw new FlowableObjectNotFoundException(TASK_ID + this.taskId + NOT_FOUND);
        }
        ExecutionEntity currentExecutionEntity = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager((CommandContext)commandContext).findById(taskEntity.getExecutionId());
        if (currentExecutionEntity == null) {
            throw new FlowableObjectNotFoundException(TASK_ID + this.taskId + NOT_FOUND);
        }
        this.currentFlowElement = currentExecutionEntity.getCurrentFlowElement();
        this.createDerivedProcessDefinitionForProcessInstance(commandContext, this.processInstanceId);
        return null;
    }

    public SequenceFlow createSequenceFlow(String from, String to) {
        SequenceFlow flow = new SequenceFlow();
        flow.setSourceRef(from);
        flow.setTargetRef(to);
        flow.setId("seq_" + UUID.randomUUID().toString());
        return flow;
    }

    protected void updateBpmnProcess(CommandContext commandContext, Process process, BpmnModel bpmnModel, ProcessDefinitionEntity originalProcessDefinitionEntity, DeploymentEntity newDeploymentEntity) {
        TaskService taskService = CommandContextUtil.getTaskService((CommandContext)commandContext);
        TaskEntity taskEntity = taskService.getTask(this.taskId);
        if (taskEntity == null) {
            throw new FlowableObjectNotFoundException(TASK_ID + this.taskId + NOT_FOUND);
        }
        ExecutionEntity currentExecutionEntity = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager((CommandContext)commandContext).findById(taskEntity.getExecutionId());
        if (currentExecutionEntity == null) {
            throw new FlowableObjectNotFoundException(TASK_ID + this.taskId + NOT_FOUND);
        }
        String activityId = currentExecutionEntity.getActivityId();
        FlowElement flowElement = process.getFlowElement(activityId, true);
        if (!(flowElement instanceof Task)) {
            throw new FlowableException(TYPE_ERROR);
        }
        if (this.currentFlowElement != null) {
            UserTask newUserTask = new UserTask();
            newUserTask.setId(this.dynamicUserTaskBuilder.getId() != null ? this.dynamicUserTaskBuilder.getId() : this.dynamicUserTaskBuilder.nextTaskId(process.getFlowElementMap()));
            this.dynamicUserTaskBuilder.setDynamicTaskId(UUID.randomUUID().toString());
            newUserTask.setName(this.dynamicUserTaskBuilder.getName());
            UserTask currentUserTask = (UserTask)this.currentFlowElement;
            newUserTask.setTaskListeners(currentUserTask.getTaskListeners());
            newUserTask.setExecutionListeners(currentUserTask.getExecutionListeners());
            ArrayList<SequenceFlow> currentUserTaskOutList = new ArrayList<SequenceFlow>();
            ArrayList<SequenceFlow> newUserTaskInFlows = new ArrayList<SequenceFlow>();
            ArrayList<SequenceFlow> newUserTaskOutFlows = new ArrayList<SequenceFlow>();
            for (SequenceFlow sequenceFlowTmp : currentUserTask.getOutgoingFlows()) {
                boolean isNext = false;
                if (ObjectUtils.isNotEmpty((Object)this.nextUserTask) || ObjectUtils.isNotEmpty((Object)this.endEvent)) {
                    isNext = true;
                }
                if (!isNext) continue;
                SequenceFlow newFlowOut = this.createSequenceFlow(newUserTask.getId(), sequenceFlowTmp.getTargetRef());
                newFlowOut.setConditionExpression(sequenceFlowTmp.getConditionExpression());
                newFlowOut.setName(sequenceFlowTmp.getName());
                newUserTaskOutFlows.add(newFlowOut);
                this.recordNewSequence(commandContext, newFlowOut, originalProcessDefinitionEntity.getId());
                process.addFlowElement((FlowElement)newFlowOut);
                SequenceFlow currentFlowOut = this.createSequenceFlow(sequenceFlowTmp.getSourceRef(), newUserTask.getId());
                currentFlowOut.setConditionExpression(sequenceFlowTmp.getConditionExpression());
                currentFlowOut.setName(sequenceFlowTmp.getName());
                newUserTaskInFlows.add(currentFlowOut);
                currentUserTaskOutList.add(currentFlowOut);
                process.addFlowElement((FlowElement)currentFlowOut);
                process.removeFlowElement(sequenceFlowTmp.getId());
                this.recordNewSequence(commandContext, currentFlowOut, originalProcessDefinitionEntity.getId());
            }
            newUserTask.setIncomingFlows(newUserTaskInFlows);
            newUserTask.setOutgoingFlows(newUserTaskOutFlows);
            currentUserTask.setOutgoingFlows(currentUserTaskOutList);
            process.addFlowElement((FlowElement)newUserTask);
            new BpmnAutoLayout(bpmnModel).execute();
            byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
            String processXml = new String(bpmnBytes);
            log.info("\u5411\u540e\u52a0\u7b7e\u6a21\u578b:\n{}", (Object)processXml);
            BaseDynamicSubProcessInjectUtil.processFlowElements((CommandContext)commandContext, (FlowElementsContainer)process, (BpmnModel)bpmnModel, (ProcessDefinitionEntity)originalProcessDefinitionEntity, (DeploymentEntity)newDeploymentEntity);
            DeploymentManager deploymentManager = CommandContextUtil.getProcessEngineConfiguration().getDeploymentManager();
            ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)CommandContextUtil.getProcessDefinitionEntityManager((CommandContext)commandContext).findById(this.processInstance.getProcessDefinitionId());
            deploymentManager.getProcessDefinitionCache().remove(processDefinitionEntity.getId());
            deploymentManager.resolveProcessDefinition((ProcessDefinition)processDefinitionEntity);
        }
    }

    protected void updateExecutions(CommandContext commandContext, ProcessDefinitionEntity processDefinitionEntity, ExecutionEntity executionEntity, List<ExecutionEntity> childExecutions) {
    }

    private void recordNewSequence(CommandContext commandContext, SequenceFlow sequenceFlow, String procDefId) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager((CommandContext)commandContext);
        List oldExecution = executionEntityManager.findChildExecutionsByProcessInstanceId(this.processInstanceId);
        HistoricActivityInstanceEntityManager historicActivityInstanceEntityManager = CommandContextUtil.getHistoricActivityInstanceEntityManager((CommandContext)commandContext);
        HistoricActivityInstanceEntity historicActivityInstanceEntity = (HistoricActivityInstanceEntity)historicActivityInstanceEntityManager.create();
        historicActivityInstanceEntity.setActivityName(sequenceFlow.getName());
        historicActivityInstanceEntity.setActivityId(sequenceFlow.getId());
        historicActivityInstanceEntity.setExecutionId(((ExecutionEntity)oldExecution.get(0)).getId());
        historicActivityInstanceEntity.setTenantId(((ExecutionEntity)oldExecution.get(0)).getTenantId());
        historicActivityInstanceEntity.setProcessInstanceId(this.processInstanceId);
        historicActivityInstanceEntity.setActivityType("sequenceFlow");
        historicActivityInstanceEntity.setProcessDefinitionId(procDefId);
        historicActivityInstanceEntity.setStartTime(new Date());
        historicActivityInstanceEntity.setEndTime(new Date());
        historicActivityInstanceEntityManager.insert((Entity)historicActivityInstanceEntity);
        System.out.println("historicActivityInstanceEntity = " + historicActivityInstanceEntity);
    }
}

